/// <reference path="../src/typedef/eslint-internal.d.ts" />
import ts from "typescript";
import { ConfigArray } from "eslint/lib/cli-engine/config-array/config-array";
export declare type ConfigProviderHost = {
    readonly readFile: (fileName: string, encoding: string) => string | undefined;
    readonly watchFile: (path: string, callback: ts.FileWatcherCallback, pollingInterval?: number) => ts.FileWatcher;
};
export declare type ESLintConfigProviderOptions = {
    host: ConfigProviderHost;
    directoriesToWatch: string[];
};
export interface ConfigProvider {
    getConfigArrayForFile(fileName: string): ConfigArray;
}
export declare class ESLintConfigProvider implements ConfigProvider {
    private readonly host;
    private readonly factory;
    constructor({ host, directoriesToWatch }: ESLintConfigProviderOptions);
    getConfigArrayForFile(fileName: string): ConfigArray<import("eslint/lib/cli-engine/config-array/extracted-config").InternalConfig>;
    getConfigForFile(fileName: string): import("eslint/lib/cli-engine/config-array/extracted-config").ExtractedConfig;
}
