/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.util.surround;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.util.surround.ISurroundTarget;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeSurroundTarget
extends ISurroundTarget<CompositeInfo, ControlInfo> {
    private final String m_className;

    public AbstractCompositeSurroundTarget(String className) {
        this.m_className = className;
    }

    public Image getIcon(AstEditor editor) throws Exception {
        return ComponentDescriptionHelper.getDescription((AstEditor)editor, (String)this.m_className).getIcon();
    }

    public String getText(AstEditor editor) throws Exception {
        return this.m_className;
    }

    public CompositeInfo createContainer(AstEditor editor) throws Exception {
        return (CompositeInfo)JavaInfoUtils.createJavaInfo((AstEditor)editor, (String)this.m_className, (CreationSupport)new ConstructorCreationSupport());
    }

    public void beforeComponentsMove(CompositeInfo container, List<ControlInfo> components) throws Exception {
        LayoutInfo layout = AbstractCompositeSurroundTarget.createLayout(container.getEditor(), "org.eclipse.swt.layout.RowLayout");
        container.setLayout(layout);
    }

    public void move(CompositeInfo container, ControlInfo component) throws Exception {
        RowLayoutInfo layout = (RowLayoutInfo)container.getLayout();
        layout.command_MOVE(component, null);
    }

    private static LayoutInfo createLayout(AstEditor editor, String layoutClassName) throws Exception {
        return (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)editor, (String)layoutClassName, (CreationSupport)new ConstructorCreationSupport());
    }
}

