/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.order;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.order.MethodOrder;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class MethodOrderAfter
extends MethodOrder {
    private final String m_targetSignature;

    public MethodOrderAfter(String targetSignature) {
        this.m_targetSignature = targetSignature;
    }

    public boolean canReference(JavaInfo javaInfo) {
        return true;
    }

    protected StatementTarget getSpecificTarget(JavaInfo javaInfo, String newSignature) throws Exception {
        List<MethodInvocation> targetInvocations = javaInfo.getMethodInvocations(this.m_targetSignature);
        if (!targetInvocations.isEmpty()) {
            AstEditor editor = javaInfo.getEditor();
            ExecutionFlowDescription flowDescription = EditorState.get(editor).getFlowDescription();
            JavaInfoUtils.sortNodesByFlow(flowDescription, false, targetInvocations);
            MethodInvocation targetInvocation = targetInvocations.get(targetInvocations.size() - 1);
            Statement targetStatement = AstNodeUtils.getEnclosingStatement((ASTNode)targetInvocation);
            return new StatementTarget(targetStatement, false);
        }
        MethodDescription targetMethod = javaInfo.getDescription().getMethod(this.m_targetSignature);
        MethodOrder targetOrder = targetMethod.getOrder();
        return targetOrder.getTarget(javaInfo, newSignature);
    }

    boolean isTarget(String newSignature) {
        return this.m_targetSignature.equals(newSignature);
    }
}

