/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public final class IDEEncoding {
    private static String IDE_ENCODINGS_PREFERENCE = "IDE_ENCODINGS_PREFERENCE";
    private static String PREFERENCE_SEPARATOR = "'";
    public static String BOM_UTF_8 = "UTF-8 (BOM)";
    public static String BOM_UTF_16BE = "UTF-16 Big-Endian (BOM)";
    public static String BOM_UTF_16LE = "UTF-16 Little-Endian (BOM)";

    private IDEEncoding() {
    }

    public static List<String> getIDEEncodings() {
        List<String> encodings = IDEEncoding.getIDEEncodingsPreference();
        encodings.addAll(WorkbenchEncoding.getDefinedEncodings());
        String enc = IDEEncoding.getResourceEncoding();
        if (enc != null && !encodings.contains(enc)) {
            encodings.add(enc);
        }
        encodings.sort(null);
        return encodings;
    }

    public static String getResourceEncoding() {
        String preference = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
        if (preference == null || preference.length() == 0) {
            return null;
        }
        return preference;
    }

    public static void addIDEEncoding(String value) {
        if (WorkbenchEncoding.getDefinedEncodings().contains(value)) {
            return;
        }
        IDEEncoding.writeEncodingsPreference(value, IDEEncoding.getIDEEncodingsPreference());
    }

    private static void writeEncodingsPreference(String value, Collection<String> encodings) {
        boolean addValue = value != null;
        StringBuilder result = new StringBuilder();
        for (String string : encodings) {
            result.append(string);
            result.append(PREFERENCE_SEPARATOR);
            if (!addValue || !string.equals(value)) continue;
            addValue = false;
        }
        if (addValue) {
            result.append(value);
        }
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(IDE_ENCODINGS_PREFERENCE, result.toString());
    }

    private static List<String> getIDEEncodingsPreference() {
        boolean updateRequired = false;
        String encodings = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(IDE_ENCODINGS_PREFERENCE);
        if (encodings == null || encodings.length() == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = encodings.split(PREFERENCE_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isSupported;
            String string = stringArray[n2];
            try {
                isSupported = Charset.isSupported(string);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                isSupported = false;
            }
            if (isSupported) {
                result.add(string);
            } else {
                WorkbenchPlugin.log((String)NLS.bind((String)IDEWorkbenchMessages.WorkbenchEncoding_invalidCharset, (Object)string));
                updateRequired = true;
            }
            ++n2;
        }
        if (updateRequired) {
            IDEEncoding.writeEncodingsPreference(null, result);
        }
        return result;
    }

    public static void clearUserEncodings() {
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setToDefault(IDE_ENCODINGS_PREFERENCE);
    }

    public static String getByteOrderMarkLabel(IContentDescription description) {
        if (description == null) {
            return null;
        }
        byte[] bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK);
        if (bom == null) {
            return null;
        }
        if (bom == IContentDescription.BOM_UTF_8) {
            return BOM_UTF_8;
        }
        if (bom == IContentDescription.BOM_UTF_16BE) {
            return BOM_UTF_16BE;
        }
        if (bom == IContentDescription.BOM_UTF_16LE) {
            return BOM_UTF_16LE;
        }
        return null;
    }
}

