/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.internal.helper.task.DnDTasksOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DropinForContainerTaskCommand
extends AbstractCommandTask {
    private DragAndDropTarget target;
    private ContainerMapping mapping;
    private DDiagramElement droppedDiagramElement;
    private EObject droppedElement;
    private EObject semanticContainer;
    private ContainerDropDescription tool;

    public DropinForContainerTaskCommand(DragAndDropTarget target, ContainerMapping mapping, DDiagramElement droppedDiagramElement, EObject droppedElement, EObject semanticContainer, ContainerDropDescription tool) {
        this.target = target;
        this.mapping = mapping;
        this.droppedDiagramElement = droppedDiagramElement;
        this.droppedElement = droppedElement;
        this.semanticContainer = semanticContainer;
        this.tool = tool;
    }

    public String getLabel() {
        return Messages.DropinForContainerTaskCommand_taskLabel;
    }

    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
        DDiagram parentDiagram = DnDTasksOperations.getParentDiagram(this.target);
        DDiagramElementContainer newDiagramElementContainer = null;
        if (this.droppedDiagramElement != null && this.mapping.equals(this.droppedDiagramElement.getMapping()) && this.droppedDiagramElement instanceof DDiagramElementContainer) {
            newDiagramElementContainer = (DDiagramElementContainer)this.droppedDiagramElement;
        } else if (this.mapping instanceof IContainerMappingExt) {
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(this.semanticContainer);
            newDiagramElementContainer = new ContainerMappingWithInterpreterHelper(interpreter).createContainer((IContainerMappingExt)this.mapping, this.droppedElement, this.semanticContainer, parentDiagram);
        }
        if (newDiagramElementContainer != null) {
            if (this.target instanceof DDiagram) {
                ((DDiagram)this.target).getOwnedDiagramElements().add((Object)newDiagramElementContainer);
            } else if (this.target instanceof DNodeContainer) {
                ((DNodeContainer)this.target).getOwnedDiagramElements().add((Object)newDiagramElementContainer);
            }
            if (this.droppedDiagramElement instanceof DNodeContainer && newDiagramElementContainer instanceof DNodeContainer) {
                DnDTasksOperations.moveSubNodes((DNodeContainer)this.droppedDiagramElement, this.droppedElement, this.tool, (DNodeContainer)newDiagramElementContainer);
            }
            if (!newDiagramElementContainer.equals(this.droppedDiagramElement)) {
                if (this.tool.isMoveEdges()) {
                    DnDTasksOperations.moveEdges(this.target, this.semanticContainer, this.droppedDiagramElement, newDiagramElementContainer);
                }
                DnDTasksOperations.deletePreviousEdges(this.target, this.droppedDiagramElement);
            }
        }
    }
}

