/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.classid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipError;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ReferenceMatch;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public final class ClassIdValidationJob
extends AbstractJob {
    public static final String CLASS_ID_VALIDATION_JOB_FAMILY = "CLASS_ID_VALIDATION_JOB_FAMILY";
    public static final String CLASS_ID_DUPLICATE_MARKER_ID = "org.eclipse.scout.sdk.classid.duplicate";
    public static final String CLASS_ID_ATTR_ANNOTATION = "SCOUT_CLASS_ID_ATTR_ANNOTATION";
    private final Set<IType> m_classIdTypes;

    private ClassIdValidationJob(Set<IType> classIdTypes, boolean showToUser) {
        super(ClassIdValidationJob.class.getName());
        this.setSystem(!showToUser);
        this.setUser(showToUser);
        this.setRule(new P_SchedulingRule());
        this.setPriority(40);
        this.m_classIdTypes = classIdTypes;
    }

    private Set<IAnnotation> getAllClassIdAnnotationsInWorkspace(final IProgressMonitor monitor) {
        final HashSet<IAnnotation> result = new HashSet<IAnnotation>();
        try {
            SearchEngine e = new SearchEngine();
            IJavaSearchScope workspaceScope = SearchEngine.createWorkspaceScope();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) {
                    IType ownerType;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException("ClassId annotation search canceled by monitor.");
                    }
                    Object owner = match.getElement();
                    if (owner instanceof IType && JdtUtils.exists((IJavaElement)(ownerType = (IType)owner))) {
                        IJavaElement element = ((ReferenceMatch)match).getLocalElement();
                        if (element == null) {
                            element = JdtUtils.getAnnotation((IAnnotatable)ownerType, "org.eclipse.scout.rt.platform.classid.ClassId");
                        }
                        if (element instanceof IAnnotation && JdtUtils.exists(element)) {
                            result.add((IAnnotation)element);
                        }
                    }
                }
            };
            for (IType classIdType : this.m_classIdTypes) {
                if (monitor.isCanceled()) {
                    return result;
                }
                if (!JdtUtils.exists((IJavaElement)classIdType)) continue;
                SearchPattern pattern = SearchPattern.createPattern((IJavaElement)classIdType, (int)65536, (int)0);
                e.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, workspaceScope, requestor, monitor);
            }
        }
        catch (IllegalStateException ise) {
            SdkLog.debug((CharSequence)"@ClassId Validation Job canceled because workspace is closing.", (Object[])new Object[]{ise});
        }
        catch (OperationCanceledException oce) {
            SdkLog.debug((CharSequence)"@ClassId Validation Job canceled because monitor was canceled.", (Object[])new Object[]{oce});
        }
        catch (ZipError ze) {
            SdkLog.warning((CharSequence)"unable to find @ClassId annotation references in workspace.", (Object[])new Object[]{ze});
        }
        catch (IllegalArgumentException iae) {
            SdkLog.info((CharSequence)"@ClassId validation job canceled.", (Object[])new Object[]{iae});
        }
        catch (RuntimeException | CoreException ex) {
            SdkLog.error((CharSequence)"unable to find @ClassId annotation references in workspace.", (Object[])new Object[]{ex});
        }
        return result;
    }

    public boolean belongsTo(Object family) {
        return CLASS_ID_VALIDATION_JOB_FAMILY.equals(family);
    }

    private Map<String, List<IAnnotation>> getClassIdOccurrences(IProgressMonitor monitor) {
        Set<IAnnotation> allClassIdAnnotationsInWorkspace = this.getAllClassIdAnnotationsInWorkspace(monitor);
        if (monitor.isCanceled()) {
            return null;
        }
        HashMap<String, List<IAnnotation>> ids = new HashMap<String, List<IAnnotation>>();
        for (IAnnotation r : allClassIdAnnotationsInWorkspace) {
            String id;
            if (monitor.isCanceled()) {
                return null;
            }
            if (!JdtUtils.exists((IJavaElement)r) || Strings.isEmpty((CharSequence)(id = JdtUtils.getAnnotationValueString(r, "value")))) continue;
            ids.computeIfAbsent(id, k -> new ArrayList()).add(r);
        }
        return ids;
    }

    private static IAnnotation getVisibleDuplicate(IJavaElement current, Iterable<IAnnotation> matchesById) {
        IJavaProject jp = current.getJavaProject();
        for (IAnnotation m : matchesById) {
            if (m == current || !JdtUtils.isOnClasspath((IJavaElement)m, jp)) continue;
            return m;
        }
        return null;
    }

    private static void createDuplicateMarkers(Map<String, List<IAnnotation>> annotations) throws CoreException {
        if (annotations == null || annotations.isEmpty()) {
            return;
        }
        for (Map.Entry<String, List<IAnnotation>> matches : annotations.entrySet()) {
            List<IAnnotation> matchesById = matches.getValue();
            if (matchesById.size() <= 1) continue;
            for (IAnnotation duplicate : matchesById) {
                IAnnotation other = ClassIdValidationJob.getVisibleDuplicate((IJavaElement)duplicate, matchesById);
                IType parent = (IType)duplicate.getAncestor(7);
                if (!JdtUtils.exists((IJavaElement)parent) || !JdtUtils.exists((IJavaElement)other)) continue;
                IType otherParent = (IType)other.getAncestor(7);
                ISourceRange sourceRange = duplicate.getSourceRange();
                if (!JdtUtils.exists((IJavaElement)otherParent) || !SourceRange.isAvailable((ISourceRange)sourceRange)) continue;
                IMarker marker = duplicate.getResource().createMarker(CLASS_ID_DUPLICATE_MARKER_ID);
                marker.setAttribute("message", (Object)("Duplicate @ClassId. Value '" + matches.getKey() + "' of type '" + parent.getFullyQualifiedName() + "' is the same as of type '" + otherParent.getFullyQualifiedName() + "'."));
                marker.setAttribute("priority", 2);
                marker.setAttribute("charStart", sourceRange.getOffset());
                marker.setAttribute("charEnd", sourceRange.getOffset() + sourceRange.getLength());
                marker.setAttribute("severity", 2);
                try {
                    Document doc = new Document(parent.getCompilationUnit().getSource());
                    marker.setAttribute("lineNumber", doc.getLineOfOffset(sourceRange.getOffset()) + 1);
                }
                catch (BadLocationException e) {
                    throw new SdkException((Throwable)e);
                }
                marker.setAttribute(CLASS_ID_ATTR_ANNOTATION, (Object)duplicate);
            }
        }
    }

    private static void deleteDuplicateMarkers() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().deleteMarkers(CLASS_ID_DUPLICATE_MARKER_ID, true, 2);
        }
        catch (CoreException e) {
            SdkLog.error((CharSequence)"unable to remove old class id duplicate markers", (Object[])new Object[]{e});
        }
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CoreException {
        Map<String, List<IAnnotation>> classIdOccurrences = this.getClassIdOccurrences(monitor);
        if (monitor.isCanceled()) {
            return;
        }
        ClassIdValidationJob.deleteDuplicateMarkers();
        ClassIdValidationJob.createDuplicateMarkers(classIdOccurrences);
    }

    public static synchronized void executeAsync(long startDelay, final boolean showToUser) {
        AbstractJob j = new AbstractJob("schedule classid validation"){

            @Override
            protected void execute(IProgressMonitor monitor) {
                try {
                    S2eUtils.waitForJdt();
                    Set<IType> classIds = JdtUtils.resolveJdtTypes("org.eclipse.scout.rt.platform.classid.ClassId");
                    if (classIds.isEmpty()) {
                        return;
                    }
                    Job.getJobManager().cancel((Object)ClassIdValidationJob.CLASS_ID_VALIDATION_JOB_FAMILY);
                    new ClassIdValidationJob(classIds, showToUser, null).schedule(TimeUnit.SECONDS.toMillis(1L));
                }
                catch (IllegalStateException e) {
                    SdkLog.info((CharSequence)"Could not schedule class id validation.", (Object[])new Object[]{e});
                }
                catch (RuntimeException e) {
                    SdkLog.error((CharSequence)"Error while preparing to search for duplicate @ClassIds.", (Object[])new Object[]{e});
                }
            }
        };
        j.setPriority(50);
        j.setSystem(true);
        j.setUser(false);
        j.schedule(startDelay);
    }

    /* synthetic */ ClassIdValidationJob(Set set, boolean bl, ClassIdValidationJob classIdValidationJob) {
        this(set, bl);
    }

    private static final class P_SchedulingRule
    implements ISchedulingRule {
        private P_SchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof P_SchedulingRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof P_SchedulingRule;
        }
    }
}

