/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.scout.sdk.core.util.JavaTypes;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AbstractAstBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstMethodBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.ILinkedPositionHolder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.WrappedTrackedNodePosition;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class AstMenuBuilder
extends AstTypeBuilder<AstMenuBuilder> {
    private MethodDeclaration m_execAction;

    protected AstMenuBuilder(AstNodeFactory owner) {
        super(owner);
    }

    @Override
    public AstMenuBuilder insert() {
        super.insert();
        if (!(AstUtils.isInstanceOf((ITypeBinding)this.getFactory().getDeclaringTypeBinding(), (String)"org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton") || AstUtils.isInstanceOf((ITypeBinding)this.getFactory().getDeclaringTypeBinding(), (String)"org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox") || AstUtils.isInstanceOf((ITypeBinding)this.getFactory().getDeclaringTypeBinding(), (String)"org.eclipse.scout.rt.client.ui.form.fields.imagefield.AbstractImageField"))) {
            this.addGetConfiguredMenuTypes();
        }
        this.m_execAction = ((AstMethodBuilder)((AstMethodBuilder)this.getFactory().newExecMethod("execAction").in(this.get())).insert()).get();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            links.addLinkedPositionProposalsHierarchy("SUPER_TYPE", "org.eclipse.scout.rt.client.ui.action.menu.IMenu");
        }
        return this;
    }

    public MethodDeclaration getExecAction() {
        return this.m_execAction;
    }

    protected void addGetConfiguredMenuTypes() {
        AST ast = this.getFactory().getAst();
        Type iMenuTypeType = this.getFactory().newTypeReference("org.eclipse.scout.rt.client.ui.action.menu.IMenuType");
        Type setType = this.getFactory().newTypeReference(Set.class.getName());
        ParameterizedType returnType = ast.newParameterizedType(setType);
        WildcardType extendsIMenuType = ast.newWildcardType();
        extendsIMenuType.setBound(iMenuTypeType, true);
        returnType.typeArguments().add(extendsIMenuType);
        MethodInvocation hashSet = ast.newMethodInvocation();
        String methodName = "hashSet";
        Type collectionUtilityType = this.getFactory().newTypeReference("org.eclipse.scout.rt.platform.util.CollectionUtility");
        hashSet.setName(ast.newSimpleName(methodName));
        String collectionUtilityRef = collectionUtilityType.toString();
        hashSet.setExpression((Expression)ast.newSimpleName(collectionUtilityRef));
        ReturnStatement returnStatement = ast.newReturnStatement();
        returnStatement.setExpression((Expression)hashSet);
        Block body = ast.newBlock();
        body.statements().add(returnStatement);
        ((AstMethodBuilder)((AbstractAstBuilder)((AstMethodBuilder)((AstMethodBuilder)((AstMethodBuilder)this.getFactory().newMethod("getConfiguredMenuTypes").withModifiers(Modifier.ModifierKeyword.PROTECTED_KEYWORD)).withOverride(true)).withReturnType((Type)returnType)).withBody(body)).in(this.get())).insert();
        ILinkedPositionHolder links = this.getFactory().getLinkedPositionHolder();
        if (links != null && this.isCreateLinks()) {
            int offset = collectionUtilityRef.length() + methodName.length() + 2;
            WrappedTrackedNodePosition typeNamePos = new WrappedTrackedNodePosition(this.getFactory().getRewrite().track((ASTNode)hashSet), offset, -offset - 1);
            links.addLinkedPosition(typeNamePos, true, "MENU_TYPE");
            MenuTypeLinkedProposal menuTypeLinkedProposal = this.getMenuTypeLinkedProposal();
            if (menuTypeLinkedProposal != null) {
                this.getFactory().getImportRewrite().addImport(menuTypeLinkedProposal.m_typeFqn, this.getFactory().getContext());
                for (String defaultVal : menuTypeLinkedProposal.m_defaultValues) {
                    hashSet.arguments().add(ast.newQualifiedName((Name)ast.newSimpleName(menuTypeLinkedProposal.m_typeSimpleName), ast.newSimpleName(defaultVal)));
                }
                if (menuTypeLinkedProposal.m_menuTypeProposals.size() > 1) {
                    for (String menuTypeProposal : menuTypeLinkedProposal.m_menuTypeProposals) {
                        links.addLinkedPositionProposal("MENU_TYPE", menuTypeProposal);
                    }
                }
            }
        }
    }

    private MenuTypeLinkedProposal getMenuTypeLinkedProposal() {
        ITypeBinding hierarchy = this.getFactory().getDeclaringTypeBinding();
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)"org.eclipse.scout.rt.client.ui.basic.table.AbstractTable")) {
            MenuTypeLinkedProposal tableMenuType = new MenuTypeLinkedProposal("org.eclipse.scout.rt.client.ui.action.menu.TableMenuType", new String[]{"SingleSelection", "MultiSelection"});
            tableMenuType.addProposal(new String[]{"EmptySpace"});
            tableMenuType.addProposal(new String[]{"EmptySpace", "Header"});
            tableMenuType.addProposal(new String[]{"EmptySpace", "SingleSelection", "MultiSelection"});
            return tableMenuType;
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)"org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField")) {
            MenuTypeLinkedProposal valueFieldMenuType = new MenuTypeLinkedProposal("org.eclipse.scout.rt.client.ui.action.menu.ValueFieldMenuType", new String[]{"NotNull"});
            valueFieldMenuType.addProposal(new String[]{"Null"});
            valueFieldMenuType.addProposal(new String[]{"Null", "NotNull"});
            return valueFieldMenuType;
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)"org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree") || AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)"org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode")) {
            MenuTypeLinkedProposal calMenuType = new MenuTypeLinkedProposal("org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType", new String[]{"SingleSelection", "MultiSelection"});
            calMenuType.addProposal(new String[]{"EmptySpace"});
            calMenuType.addProposal(new String[]{"SingleSelection", "MultiSelection", "EmptySpace"});
            return calMenuType;
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)"org.eclipse.scout.rt.client.ui.form.fields.tabbox.AbstractTabBox")) {
            return new MenuTypeLinkedProposal("org.eclipse.scout.rt.client.ui.action.menu.TabBoxMenuType", new String[]{"Header"});
        }
        if (AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)"org.eclipse.scout.rt.client.ui.basic.calendar.provider.AbstractCalendarItemProvider") || AstUtils.isInstanceOf((ITypeBinding)hierarchy, (String)"org.eclipse.scout.rt.client.ui.basic.calendar.AbstractCalendar")) {
            MenuTypeLinkedProposal calMenuType = new MenuTypeLinkedProposal("org.eclipse.scout.rt.client.ui.action.menu.CalendarMenuType", new String[]{"CalendarComponent"});
            calMenuType.addProposal(new String[]{"EmptySpace"});
            calMenuType.addProposal(new String[]{"CalendarComponent"});
            calMenuType.addProposal(new String[]{"EmptySpace", "CalendarComponent"});
            return calMenuType;
        }
        return null;
    }

    private static final class MenuTypeLinkedProposal {
        private final String m_typeFqn;
        private final String m_typeSimpleName;
        private final List<String> m_defaultValues;
        private final List<String> m_menuTypeProposals;

        private MenuTypeLinkedProposal(String typeFqn, String ... defaultValues) {
            this.m_typeFqn = typeFqn;
            this.m_typeSimpleName = JavaTypes.simpleName((CharSequence)typeFqn);
            this.m_defaultValues = new ArrayList<String>(defaultValues.length);
            Collections.addAll(this.m_defaultValues, defaultValues);
            this.m_menuTypeProposals = new ArrayList<String>();
            this.addProposal(defaultValues);
        }

        private void addProposal(String ... simpleNames) {
            StringBuilder builder = new StringBuilder();
            if (simpleNames != null && simpleNames.length > 0) {
                builder.append(this.m_typeSimpleName).append('.').append(simpleNames[0]);
                int i = 1;
                while (i < simpleNames.length) {
                    builder.append(", ").append(this.m_typeSimpleName).append('.').append(simpleNames[i]);
                    ++i;
                }
            }
            this.m_menuTypeProposals.add(builder.toString());
        }
    }
}

