/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IUserAuthenticatorService;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.JSchUserInfo;
import org.eclipse.remote.internal.proxy.core.Activator;
import org.eclipse.remote.internal.proxy.core.messages.Messages;
import org.eclipse.remote.proxy.protocol.core.StreamChannelManager;
import org.osgi.framework.Bundle;

public class ProxyConnectionBootstrap {
    private final IJSchService jSchService = Activator.getService(IJSchService.class);
    private Session session;
    private ChannelExec exec;

    public StreamChannelManager run(IRemoteConnection connection, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            String line;
            final Channel chan = this.openChannel(connection, (IProgressMonitor)subMon.newChild(10));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(chan.getOutputStream()));
            BufferedReader reader = new BufferedReader(new InputStreamReader(chan.getInputStream()));
            subMon.beginTask(Messages.ProxyConnectionBootstrap_5, 10);
            subMon.subTask(Messages.ProxyConnectionBootstrap_9);
            URL fileURL = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("bootstrap.sh"), null);
            if (fileURL == null) {
                throw new RemoteConnectionException(Messages.ProxyConnectionBootstrap_6);
            }
            File file = new File(FileLocator.toFileURL((URL)fileURL).getFile());
            BufferedReader scriptReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            while ((line = scriptReader.readLine()) != null) {
                writer.write(String.valueOf(line) + "\n");
            }
            scriptReader.close();
            writer.flush();
            subMon.worked(2);
            Context context = new Context(reader, writer, (IProgressMonitor)subMon.newChild(8));
            while (context.getState().process(context)) {
            }
            if (context.getState() != States.START) {
                context.writer.write("exit\n");
                context.writer.flush();
                throw new RemoteConnectionException(NLS.bind((String)Messages.ProxyConnectionBootstrap_7, (Object)context.getErrorMessage()));
            }
            new Thread("server error stream"){

                @Override
                public void run() {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(chan.getExtInputStream()));
                        while ((line = reader.readLine()) != null) {
                            System.err.println("server: " + line);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            return new StreamChannelManager(chan.getInputStream(), chan.getOutputStream());
        }
        catch (IOException | CoreException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private Channel openChannel(IRemoteConnection connection, IProgressMonitor monitor) throws RemoteConnectionException {
        IRemoteConnectionWorkingCopy wc = connection.getWorkingCopy();
        IRemoteConnectionHostService hostService = (IRemoteConnectionHostService)wc.getService(IRemoteConnectionHostService.class);
        IUserAuthenticatorService authService = (IUserAuthenticatorService)wc.getService(IUserAuthenticatorService.class);
        try {
            this.session = this.jSchService.createSession(hostService.getHostname(), hostService.getPort(), hostService.getUsername());
            this.session.setUserInfo((UserInfo)new JSchUserInfo(hostService, authService));
            if (hostService.usePassword()) {
                this.session.setConfig("PreferredAuthentications", "password,keyboard-interactive,gssapi-with-mic,publickey");
            } else {
                this.session.setConfig("PreferredAuthentications", "publickey,gssapi-with-mic,password,keyboard-interactive");
            }
            String password = hostService.getPassword();
            if (!password.isEmpty()) {
                this.session.setPassword(password);
            }
            this.jSchService.connect(this.session, hostService.getTimeout() * 1000, monitor);
            if (monitor.isCanceled()) {
                throw new RemoteConnectionException(Messages.ProxyConnectionBootstrap_8);
            }
            this.exec = (ChannelExec)this.session.openChannel("exec");
            this.exec.setCommand("/bin/bash -l");
            this.exec.connect();
            return this.exec;
        }
        catch (JSchException e) {
            throw new RemoteConnectionException(e.getMessage());
        }
    }

    private class Context {
        private State state;
        private String osName;
        private String osArch;
        private String errorMessage;
        private final SubMonitor monitor;
        private final BufferedReader reader;
        private final BufferedWriter writer;

        public Context(BufferedReader reader, BufferedWriter writer, IProgressMonitor monitor) {
            this.reader = reader;
            this.writer = writer;
            this.monitor = SubMonitor.convert((IProgressMonitor)monitor);
            this.setState(States.INIT);
        }

        State getState() {
            return this.state;
        }

        SubMonitor getMonitor() {
            return this.monitor;
        }

        void setState(State state) {
            this.state = state;
        }

        String getOSName() {
            return this.osName;
        }

        void setOSName(String osName) {
            this.osName = osName;
        }

        String getOSArch() {
            return this.osArch;
        }

        void setOSArch(String osArch) {
            this.osArch = osArch;
        }

        void setErrorMessage(String message) {
            this.errorMessage = message;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }
    }

    private static interface State {
        public boolean process(Context var1) throws IOException;
    }

    private static enum States implements State
    {
        INIT{

            @Override
            public boolean process(Context context) throws IOException {
                context.getMonitor().subTask(Messages.ProxyConnectionBootstrap_0);
                String line = context.reader.readLine();
                context.getMonitor().worked(1);
                if (line.equals("running")) {
                    context.setState(CHECK);
                    return true;
                }
                return false;
            }
        }
        ,
        CHECK{

            @Override
            public boolean process(Context context) throws IOException {
                context.getMonitor().subTask(Messages.ProxyConnectionBootstrap_1);
                String bundleName = "org.eclipse.remote.proxy.server.core";
                Bundle serverBundle = Platform.getBundle((String)bundleName);
                if (serverBundle == null) {
                    throw new IOException(NLS.bind((String)Messages.ProxyConnectionBootstrap_2, (Object)bundleName));
                }
                context.writer.write("check " + serverBundle.getVersion() + "\n");
                context.writer.flush();
                String line = context.reader.readLine();
                while (line != null) {
                    context.getMonitor().worked(2);
                    String[] parts = line.split(":");
                    switch (parts[0]) {
                        case "ok": {
                            String[] status = parts[1].split("/");
                            context.setOSName(status[1]);
                            context.setOSArch(status[2]);
                            context.setState(status[0].equals("found") ? START : DOWNLOAD);
                            return true;
                        }
                        case "fail": {
                            context.setErrorMessage(parts[1]);
                            System.out.println("fail:" + parts[1]);
                            return false;
                        }
                        case "debug": {
                            System.err.println(line);
                            break;
                        }
                        default: {
                            System.err.println("Invalid response from bootstrap script: " + line);
                            return false;
                        }
                    }
                    line = context.reader.readLine();
                }
                return false;
            }
        }
        ,
        DOWNLOAD{

            @Override
            public boolean process(Context context) throws IOException {
                block16: {
                    context.getMonitor().subTask(Messages.ProxyConnectionBootstrap_3);
                    String bundleName = "org.eclipse.remote.proxy.server." + context.getOSName() + "." + context.getOSArch();
                    Bundle serverBundle = Platform.getBundle((String)bundleName);
                    if (serverBundle == null) {
                        throw new IOException(NLS.bind((String)Messages.ProxyConnectionBootstrap_2, (Object)bundleName));
                    }
                    URL fileURL = FileLocator.find((Bundle)serverBundle, (IPath)new Path("proxy.server.tar.gz"), null);
                    if (fileURL == null) {
                        return false;
                    }
                    File file = new File(FileLocator.toFileURL((URL)fileURL).getFile());
                    long count = file.length() / 510L;
                    context.writer.write("download " + count + "\n");
                    context.writer.flush();
                    context.getMonitor().worked(2);
                    if (!this.downloadFile(file, context.writer, (IProgressMonitor)context.getMonitor().newChild(5))) break block16;
                    String line = context.reader.readLine();
                    while (line != null) {
                        String[] parts = line.split(":");
                        switch (parts[0]) {
                            case "ok": {
                                context.setState(START);
                                return true;
                            }
                            case "fail": {
                                context.setErrorMessage(parts[1]);
                                System.out.println("fail:" + parts[1]);
                                return false;
                            }
                            case "debug": {
                                System.err.println(line);
                                break;
                            }
                            default: {
                                System.err.println("Invalid response from bootstrap script: " + line);
                                return false;
                            }
                        }
                        line = context.reader.readLine();
                    }
                }
                return false;
            }

            private boolean downloadFile(File file, BufferedWriter writer, IProgressMonitor monitor) {
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                try {
                    int n;
                    Base64.Encoder encoder = Base64.getEncoder();
                    FileInputStream in = new FileInputStream(file);
                    byte[] buf = new byte[510];
                    while ((n = in.read(buf)) >= 0) {
                        if (n < 510) {
                            writer.write(String.valueOf(encoder.encodeToString(Arrays.copyOf(buf, n))) + "\n");
                        } else {
                            writer.write(encoder.encodeToString(buf));
                        }
                        subMon.setWorkRemaining(8);
                    }
                    writer.flush();
                    in.close();
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        ,
        START{

            @Override
            public boolean process(Context context) throws IOException {
                context.getMonitor().subTask(Messages.ProxyConnectionBootstrap_4);
                context.writer.write("start\n");
                context.writer.flush();
                return false;
            }
        };

    }
}

