/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuItemHandler
extends ItemHandler {
    private static final Logger log = Logger.getLogger(MenuItemHandler.class);
    private static MenuItemHandler instance;

    public static MenuItemHandler getInstance() {
        if (instance == null) {
            instance = new MenuItemHandler();
        }
        return instance;
    }

    public boolean isSelected(final MenuItem item) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                if ((item.getStyle() & 0x10) != 0 || (item.getStyle() & 0x20) != 0) {
                    return item.getSelection();
                }
                return false;
            }
        });
    }

    public Menu getParent(final MenuItem item) {
        return (Menu)Display.syncExec((ResultRunnable)new ResultRunnable<Menu>(){

            public Menu run() {
                return item.getParent();
            }
        });
    }

    public void select(final MenuItem item) {
        if (!this.isEnabled(item)) {
            throw new CoreLayerException("Menu item is not enabled");
        }
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((item.getStyle() & 0x10) != 0 || (item.getStyle() & 0x20) != 0) {
                    item.setSelection(!item.getSelection());
                }
            }
        });
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Event event = MenuItemHandler.this.createSelectionEvent(item);
                log.info("Select menu item: " + item.getText());
                item.notifyListeners(13, event);
            }
        });
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public String getMenuItemText(final MenuItem i) {
        String text = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return i.getText();
            }
        });
        log.debug("Queried MenuItem text:\"" + text + "\"");
        return text;
    }

    public boolean isEnabled(final MenuItem item) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return item.getEnabled();
            }
        });
    }

    public Menu getMenuFromMenuItem(final MenuItem item) {
        return (Menu)Display.syncExec((ResultRunnable)new ResultRunnable<Menu>(){

            public Menu run() {
                return item.getMenu();
            }
        });
    }

    public String[] getMenuPath(final MenuItem item) {
        List titles = (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<String>>(){

            public List<String> run() {
                MenuItem i = item;
                ArrayList<String> titles = new ArrayList<String>();
                while (i != null) {
                    titles.add(i.getText());
                    i = i.getParent().getParentItem();
                }
                return titles;
            }
        });
        ArrayList<String> path = new ArrayList<String>(titles.size());
        for (String title : titles) {
            path.add(this.getLabelFromText(title));
        }
        Collections.reverse(path);
        return path.toArray(new String[1]);
    }

    public String getLabelFromText(String text) {
        String label = text.trim();
        if (label.contains("\t")) {
            label = label.substring(0, label.indexOf("\t"));
        }
        return label;
    }

    private Event createSelectionEvent(MenuItem menuItem) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = menuItem;
        event.item = menuItem;
        event.display = menuItem.getDisplay();
        event.type = 13;
        return event;
    }

    public Menu getMenu(final MenuItem swtWidget) {
        return (Menu)Display.syncExec((ResultRunnable)new ResultRunnable<Menu>(){

            public Menu run() {
                return swtWidget.getMenu();
            }
        });
    }
}

