/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class LinkHandler
extends ControlHandler {
    private static LinkHandler instance;

    public static LinkHandler getInstance() {
        if (instance == null) {
            instance = new LinkHandler();
        }
        return instance;
    }

    public List<String> getAnchorTexts(Link link) {
        String linkText = this.getTextInternal(link);
        ArrayList<String> anchorTextList = new ArrayList<String>();
        for (AnchorPair anchorPair : this.parseLinks(linkText)) {
            anchorTextList.add(anchorPair.getAnchorText());
        }
        return anchorTextList;
    }

    public String getEventText(Link link, String text, int index) {
        String linkText = this.getTextInternal(link);
        int counter = 0;
        for (AnchorPair ap : this.parseLinks(linkText)) {
            if (!ap.getAnchorText().equals(text)) continue;
            if (counter != index) {
                ++counter;
                continue;
            }
            return ap.getAnchorHref().equals("") ? ap.getAnchorText() : ap.getAnchorHref();
        }
        throw new CoreLayerException("There is no anchor with text [" + text + "] and index " + index + " in this link");
    }

    public String getEventText(Link link, int index) {
        String linkText = this.getTextInternal(link);
        List<AnchorPair> list = this.parseLinks(linkText);
        if (list.size() <= index) {
            throw new CoreLayerException("There are only " + list.size() + " anchors in this link and you requested anchor #" + index);
        }
        Collections.sort(list);
        AnchorPair ap = list.get(index);
        return ap.getAnchorHref().equals("") ? ap.getAnchorText() : ap.getAnchorHref();
    }

    public String getText(Link link) {
        return this.getTextInternal(link).replaceAll("<[aA]([^>]*)>(.+?)</[aA]>", "$2");
    }

    public void activate(final Link link, final String text) {
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                link.setFocus();
                LinkHandler.this.notifyWidget(3, (Widget)link);
                LinkHandler.this.notifySelection(link, text);
                LinkHandler.this.notifyWidget(4, (Widget)link);
            }
        });
    }

    private List<AnchorPair> parseLinks(String linkText) {
        ArrayList<AnchorPair> list = new ArrayList<AnchorPair>();
        Pattern p = Pattern.compile("<[aA]([^>]*)>(.+?)</[aA]>");
        Matcher m = p.matcher(linkText);
        int counter = 0;
        while (m.find()) {
            list.add(new AnchorPair(counter, m.group(2), this.parseHref(m.group(1))));
            ++counter;
        }
        return list;
    }

    private String parseHref(String text) {
        return text.replaceAll(".*href=\"([^\"]*).*", "$1");
    }

    private String getTextInternal(final Link l) {
        String text = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return l.getText();
            }
        });
        return text;
    }

    private void notifySelection(Link link, String text) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = link;
        event.display = Display.getDisplay();
        event.text = text;
        event.type = 13;
        link.notifyListeners(event.type, event);
    }

    private class AnchorPair
    implements Comparable<AnchorPair> {
        private int index;
        private String anchorText;
        private String anchorHref;

        public AnchorPair(int index, String anchorText, String anchorHref) {
            this.anchorHref = anchorHref;
            this.anchorText = anchorText;
        }

        public int getIndex() {
            return this.index;
        }

        public String getAnchorHref() {
            return this.anchorHref;
        }

        public String getAnchorText() {
            return this.anchorText;
        }

        @Override
        public int compareTo(AnchorPair o) {
            return o.getIndex() - this.index;
        }
    }
}

