/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.deploy;

import java.util.HashMap;
import java.util.Map;

public class DeployFilter {
    private static final String[] BASIC_FILTERS = new String[]{".settings", ".project", ".cache", ".svn", "CVS"};
    private static DeployFilter instance;
    private Map<String, String> filters = new HashMap<String, String>();

    private static DeployFilter getInstance() {
        if (instance == null) {
            instance = new DeployFilter();
        }
        return instance;
    }

    private DeployFilter() {
        int i = 0;
        while (i < BASIC_FILTERS.length) {
            this.filters.put(BASIC_FILTERS[i], BASIC_FILTERS[i]);
            ++i;
        }
    }

    public static Map<String, String> getFilterMap() {
        DeployFilter filter = DeployFilter.getInstance();
        HashMap<String, String> map = new HashMap<String, String>(filter.filters);
        return map;
    }

    public static void addFilter(String fileName) {
        DeployFilter.getInstance().filters.put(fileName, fileName);
    }

    public static void removeFilter(String fileName) {
        DeployFilter.getInstance().filters.remove(fileName);
    }

    public static void resetToDefault() {
        DeployFilter filter = DeployFilter.getInstance();
        filter.filters.clear();
        int i = 0;
        while (i < BASIC_FILTERS.length) {
            filter.filters.put(BASIC_FILTERS[i], BASIC_FILTERS[i]);
            ++i;
        }
    }
}

