/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.server.core.builtin.Messages;
import org.eclipse.php.internal.server.core.builtin.PHPRuntime;
import org.eclipse.php.internal.server.core.builtin.Trace;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public class PHPRuntimeLocator
extends RuntimeLocatorDelegate {
    private static final String[] PHP_CANDIDATE_BIN = new String[]{"php", "php-cli", "php-cgi", "php.exe", "php-cli.exe", "php-cgi.exe"};
    protected static final String[] runtimeTypes = new String[]{"org.eclipse.php.server.runtime.54", "org.eclipse.php.server.runtime.55", "org.eclipse.php.server.runtime.56", "org.eclipse.php.server.runtime.70", "org.eclipse.php.server.runtime.71", "org.eclipse.php.server.runtime.72", "org.eclipse.php.server.runtime.73"};

    public void searchForRuntimes(IPath path, RuntimeLocatorDelegate.IRuntimeSearchListener listener, IProgressMonitor monitor) {
        ArrayList<File> locations = new ArrayList<File>();
        ArrayList<PHPexeItem> found = new ArrayList<PHPexeItem>();
        this.searchForRuntimes2(path.toFile(), locations, monitor);
        if (!locations.isEmpty()) {
            monitor.setTaskName(Messages.PHPRuntimeLocator_Processing_search_results);
            Iterator iter2 = locations.iterator();
            while (iter2.hasNext()) {
                AbstractDebuggerConfiguration[] debuggers;
                if (monitor.isCanceled()) break;
                File location = (File)iter2.next();
                PHPexeItem phpExe = new PHPexeItem(null, location, null, null, true);
                if (phpExe.getName() == null) continue;
                String nameCopy = new String(phpExe.getName());
                monitor.subTask(MessageFormat.format(Messages.PHPRuntimeLocator_Fetching_php_exe_info, nameCopy));
                List modules = PHPExeUtil.getModules((PHPexeItem)phpExe);
                AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
                int n = debuggers.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
                    for (PHPExeUtil.PHPModuleInfo m : modules) {
                        if (!m.getName().equalsIgnoreCase(debugger.getModuleId())) continue;
                        phpExe.setDebuggerID(debugger.getDebuggerId());
                        break;
                    }
                    ++n2;
                }
                if (phpExe.getDebuggerID() == null) {
                    phpExe.setDebuggerID("org.eclipse.php.debug.core.noneDebugger");
                }
                phpExe.setName(nameCopy);
                phpExe.setLoadDefaultINI(true);
                if (phpExe.getExecutable() == null) continue;
                found.add(phpExe);
            }
        }
        for (PHPexeItem phpExe : found) {
            IRuntimeWorkingCopy runtime = PHPRuntimeLocator.getRuntimeFromDir(phpExe, monitor);
            if (runtime == null) continue;
            PHPexes.getInstance().addItem(phpExe);
            listener.runtimeFound(runtime);
        }
    }

    protected void searchForRuntimes2(File directory, List<File> found, IProgressMonitor monitor) {
        String[] names;
        if (monitor.isCanceled()) {
            return;
        }
        List<File> foundExecs = PHPRuntimeLocator.findPHPExecutable(directory);
        if (!foundExecs.isEmpty()) {
            found.addAll(foundExecs);
            monitor.setTaskName(MessageFormat.format(Messages.PHPRuntimeLocator_Searching_with_found, found.size()));
        }
        if ((names = directory.list()) == null) {
            return;
        }
        ArrayList<File> subDirs = new ArrayList<File>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, element);
            if (file.isDirectory()) {
                try {
                    monitor.subTask(MessageFormat.format(Messages.PHPRuntimeLocator_14, file.getCanonicalPath()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (monitor.isCanceled()) {
                    return;
                }
                subDirs.add(file);
            }
            ++n2;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            this.searchForRuntimes2(subDir, found, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    private static List<File> findPHPExecutable(File phpLocation) {
        ArrayList<File> found = new ArrayList<File>(0);
        String[] stringArray = PHP_CANDIDATE_BIN;
        int n = PHP_CANDIDATE_BIN.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File phpExecFile = new File(phpLocation, element);
            if (phpExecFile.exists() && !phpExecFile.isDirectory()) {
                found.add(phpExecFile);
            }
            ++n2;
        }
        return found;
    }

    protected static IRuntimeWorkingCopy getRuntimeFromDir(PHPexeItem phpExe, IProgressMonitor monitor) {
        int i = 0;
        while (i < runtimeTypes.length) {
            try {
                IStatus status;
                IRuntimeType runtimeType = ServerCore.findRuntimeType((String)runtimeTypes[i]);
                String absolutePath = phpExe.getExecutable().getParent();
                String id = absolutePath.replace(File.separatorChar, '_').replace(':', '-');
                IRuntimeWorkingCopy runtime = runtimeType.createRuntime(id, monitor);
                runtime.setName(phpExe.getName());
                runtime.setLocation((IPath)new Path(absolutePath));
                PHPRuntime phpRuntime = (PHPRuntime)runtime.loadAdapter(PHPRuntime.class, monitor);
                if (phpRuntime != null) {
                    phpRuntime.setExecutableInstall(phpExe);
                }
                if ((status = runtime.validate(monitor)) == null || status.getSeverity() != 4) {
                    return runtime;
                }
                Trace.trace((byte)4, "False runtime found at " + absolutePath + ": " + status.getMessage());
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not find runtime", e);
            }
            ++i;
        }
        return null;
    }
}

