/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.namereferences;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.emf.utils.TextReferencesHelper;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class NameReferencesHelper
extends TextReferencesHelper {
    private ChangeDispatcher listener = new ChangeDispatcher();
    private boolean dispatch = true;

    public NameReferencesHelper() {
    }

    public NameReferencesHelper(Resource baseResource) {
        super(baseResource);
    }

    protected String decorate(String text) {
        return "<u>" + text + "</u>";
    }

    public String replaceReferences(String text) {
        this.listener.clearElementListeners();
        this.dispatch = false;
        String result = super.replaceReferences(text);
        this.dispatch = true;
        return result;
    }

    protected String getReplacement(EObject elementToReplace, String cachedValue) {
        if (elementToReplace == null) {
            return "UNKNOWN";
        }
        if (elementToReplace.eIsProxy()) {
            return "PROXY";
        }
        if (elementToReplace instanceof NamedElement) {
            NamedElement target = (NamedElement)elementToReplace;
            if (this.installListeners()) {
                if (!target.eAdapters().contains((Object)this.listener)) {
                    this.listener.listenOnElement((Notifier)target);
                }
                if (!target.eResource().eAdapters().contains((Object)this.listener)) {
                    this.listener.listenOnElement((Notifier)target.eResource());
                }
                if (target.eContainer() != null && !target.eContainer().eAdapters().contains((Object)this.listener)) {
                    this.listener.listenOnElement((Notifier)target.eContainer());
                }
            }
            if (target.getName() == null) {
                return "UNNAMED";
            }
            return UMLLabelInternationalization.getInstance().getLabel(target);
        }
        if (cachedValue == null) {
            return "UNKNOWN";
        }
        return String.valueOf(cachedValue) + " (Missing)";
    }

    private boolean installListeners() {
        return !this.listener.listeners.isEmpty();
    }

    public void addListener(Adapter listener) {
        this.listener.addListener(listener);
    }

    public void removeListener(Adapter listener) {
        this.listener.removeListener(listener);
    }

    public void dispose() {
        this.listener.dispose();
        this.resourceSet = null;
        this.baseResource = null;
    }

    private class ChangeDispatcher
    extends AdapterImpl {
        private final Set<Adapter> listeners = new HashSet<Adapter>();
        private final Set<Notifier> listenOnElements = new HashSet<Notifier>();

        private ChangeDispatcher() {
        }

        public void notifyChanged(Notification msg) {
            try {
                if (NameReferencesHelper.this.dispatch && this.isValidNotification(msg)) {
                    for (Adapter listener : this.listeners) {
                        try {
                            listener.notifyChanged(msg);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        boolean isValidNotification(Notification msg) {
            if (!this.listenOnElements.contains(msg.getNotifier())) {
                Object notifierObject = msg.getNotifier();
                if (notifierObject instanceof Notifier) {
                    ((Notifier)notifierObject).eAdapters().remove((Object)this);
                }
                return false;
            }
            if (msg.getFeature() == UMLPackage.eINSTANCE.getNamedElement_Name()) {
                return true;
            }
            if (msg.getNotifier() instanceof Resource) {
                return true;
            }
            Object feature = msg.getFeature();
            return feature instanceof EReference && ((EReference)feature).isContainment();
        }

        public void addListener(Adapter listener) {
            this.listeners.add(listener);
        }

        public void removeListener(Adapter listener) {
            this.listeners.remove(listener);
        }

        private void listenOnElement(Notifier element) {
            if (element.eAdapters().contains((Object)this)) {
                return;
            }
            this.listenOnElements.add(element);
            element.eAdapters().add((Object)this);
        }

        private void clearElementListeners() {
            LinkedList<Notifier> notifiers = new LinkedList<Notifier>(this.listenOnElements);
            for (Notifier notifier : notifiers) {
                notifier.eAdapters().remove((Object)this);
            }
            this.listenOnElements.clear();
        }

        public void dispose() {
            this.listeners.clear();
            this.clearElementListeners();
        }
    }
}

