/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.strategy.paste;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.AbstractPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.DefaultPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.uml.tools.commands.RenameElementCommand;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.NamedElement;

public class RenamePasteStrategy
extends AbstractPasteStrategy
implements IPasteStrategy {
    private static IPasteStrategy instance = new RenamePasteStrategy();

    public static IPasteStrategy getInstance() {
        return instance;
    }

    public String getLabel() {
        return "Rename Strategy";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.common.RenameStrategy";
    }

    public String getDescription() {
        return "Rename elements";
    }

    public IPasteStrategy dependsOn() {
        return DefaultPasteStrategy.getInstance();
    }

    public Command getSemanticCommand(EditingDomain domain, EObject targetOwner, PapyrusClipboard<Object> papyrusClipboard) {
        CompoundCommand compoundCommand = new CompoundCommand("Rename root paste elements");
        List filterDescendants = EcoreUtil.filterDescendants((Collection)papyrusClipboard.getTarget());
        for (EObject target : filterDescendants) {
            NamedElement namedElement;
            if (!(target instanceof NamedElement) || (namedElement = (NamedElement)target).getName() == null) continue;
            String defaultCopyNameWithIncrement = NamedElementUtil.getDefaultCopyNameWithIncrement((NamedElement)namedElement, (Collection)targetOwner.eContents());
            RenameElementCommand renameElementCommand = new RenameElementCommand((TransactionalEditingDomain)domain, namedElement, defaultCopyNameWithIncrement);
            compoundCommand.append((Command)renameElementCommand);
        }
        if (compoundCommand.getCommandList().isEmpty()) {
            return null;
        }
        return compoundCommand;
    }
}

