/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.URIUtil;

public class DebugUtil {
    public static @NonNull URI createDebugDocument(@NonNull EnvironmentFactory environmentFactory, @Nullable EObject contextObject, @NonNull String expression, IProgressMonitor monitor) throws CoreException, IOException {
        IdResolver idResolver = environmentFactory.getIdResolver();
        Class staticType = idResolver.getStaticTypeOfValue(null, (Object)contextObject);
        Class contextType = environmentFactory.getMetamodelManager().getPrimaryClass(staticType);
        Package contextPackage = contextType.getOwningPackage();
        IPath documentPath = DebugVMUIPlugin.getDefault().getStateLocation().append("debug" + EcoreUtil.generateUUID() + ".ocl");
        IFileStore documentStore = EFS.getLocalFileSystem().getStore(documentPath);
        OutputStream documentStream = documentStore.openOutputStream(0, monitor);
        PrettyPrintOptions.Global printOptions = PrettyPrinter.createOptions(null);
        printOptions.addReservedNames((Iterable)PrettyPrinter.restrictedNameList);
        OutputStreamWriter s = new OutputStreamWriter(documentStream);
        URI externalURI = null;
        if (contextPackage != null) {
            Model containingRoot = PivotUtil.getContainingModel((EObject)contextPackage);
            if (containingRoot == null) {
                externalURI = URI.createURI((String)contextPackage.getURI());
            } else if (containingRoot != PivotUtil.getContainingModel((EObject)environmentFactory.getStandardLibrary().getOclAnyType())) {
                externalURI = URI.createURI((String)containingRoot.getExternalURI());
                externalURI = URIUtil.getNonASURI((URI)externalURI);
            }
            if (externalURI != null) {
                externalURI = URIUtil.getAbsoluteOrPlatformURI((URI)externalURI);
                ((Writer)s).append("import '" + externalURI + "'\n\n");
            }
        }
        ((Writer)s).append("context ");
        if (externalURI == null) {
            ((Writer)s).append("ocl::");
        }
        ((Writer)s).append(String.valueOf(PrettyPrinter.printName((Element)contextType, (PrettyPrintOptions)printOptions)) + "\n");
        ((Writer)s).append("def: oclDebuggerExpression() : OclAny = \n\t");
        ((Writer)s).append(expression.replace("\n", "\n\t"));
        ((Writer)s).append("\n");
        ((Writer)s).close();
        java.net.URI documentURI1 = documentStore.toURI();
        @NonNull URI documentURI2 = URI.createURI((String)documentURI1.toString());
        return documentURI2;
    }
}

