/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import java.util.Arrays;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.ui.editors.TextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LabelsAttributeEditor
extends TextAttributeEditor {
    private static final String VALUE_SEPARATOR = ",";
    private final boolean isMultiSelect;

    public LabelsAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        boolean bl = this.isMultiSelect = "multiSelect".equals(taskAttribute.getMetaData().getType()) || "multiLabel".equals(taskAttribute.getMetaData().getType());
        if (!this.isReadOnly() && this.isMultiSelect) {
            this.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.MULTIPLE, LayoutHint.ColumnSpan.SINGLE));
        }
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit, this.getLayoutHint() != null && this.getLayoutHint().rowSpan == LayoutHint.RowSpan.MULTIPLE ? 64 : 0);
        if (!this.isReadOnly() && this.isMultiSelect) {
            this.getText().setToolTipText("Separate multiple values with a comma");
        }
    }

    @Override
    public String getValue() {
        if (this.isMultiSelect) {
            List values = this.getAttributeMapper().getValues(this.getTaskAttribute());
            return Joiner.on((String)", ").skipNulls().join((Iterable)values);
        }
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    @Override
    public void setValue(String text) {
        if (this.isMultiSelect) {
            String[] values = text.split(VALUE_SEPARATOR);
            this.getAttributeMapper().setValues(this.getTaskAttribute(), LabelsAttributeEditor.getTrimmedValues(values));
        } else {
            this.getAttributeMapper().setValue(this.getTaskAttribute(), text);
        }
        this.attributeChanged();
    }

    public static List<String> getTrimmedValues(String[] values) {
        return FluentIterable.from(Arrays.asList(values)).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return Strings.nullToEmpty((String)input).trim();
            }
        }).filter((Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !Strings.isNullOrEmpty((String)input);
            }
        }).toList();
    }
}

