/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.custom.editor.editors;

import java.util.EventObject;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.modisco.infra.browser.custom.editor.editors.CustomizationEditor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;

public class CustomizationEditorActionBarContributor
extends EditorActionBarContributor {
    private UndoAction undoAction;
    private RedoAction redoAction;
    private final CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            CustomizationEditorActionBarContributor.this.undoAction.update();
            CustomizationEditorActionBarContributor.this.redoAction.update();
        }
    };

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof CustomizationEditor) {
            CustomizationEditor customizationEditor = (CustomizationEditor)targetEditor;
            EditingDomain editingDomain = customizationEditor.getEditingDomain();
            this.undoAction.setEditingDomain(editingDomain);
            this.redoAction.setEditingDomain(editingDomain);
            this.undoAction.update();
            this.redoAction.update();
            CommandStack commandStack = customizationEditor.getEditingDomain().getCommandStack();
            commandStack.removeCommandStackListener(this.commandStackListener);
            commandStack.addCommandStackListener(this.commandStackListener);
        }
    }
}

