/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;

public class SwtKeyCodeConverter {
    private static AutServerLogger log = new AutServerLogger(SwtKeyCodeConverter.class);
    private static final Map<String, Character> CHAR_MAP = new HashMap<String, Character>();
    private static final Map<String, Integer> KEY_MAP;
    private static final Map<String, Integer> MOD_MAP;
    private static final Map<Integer, String> KEYCODE_MAP;
    private static final Map<Integer, String> MODIFIER_MAP;

    static {
        CHAR_MAP.put("SPACE", new Character(' '));
        KEY_MAP = new HashMap<String, Integer>();
        KEY_MAP.put("ENTER", new Integer(13));
        KEY_MAP.put("TAB", new Integer(9));
        KEY_MAP.put("ESCAPE", new Integer(27));
        KEY_MAP.put("BACK_SPACE", new Integer(8));
        KEY_MAP.put("F1", new Integer(0x100000A));
        KEY_MAP.put("F2", new Integer(0x100000B));
        KEY_MAP.put("F3", new Integer(0x100000C));
        KEY_MAP.put("F4", new Integer(0x100000D));
        KEY_MAP.put("F5", new Integer(0x100000E));
        KEY_MAP.put("F6", new Integer(0x100000F));
        KEY_MAP.put("F7", new Integer(0x1000010));
        KEY_MAP.put("F8", new Integer(0x1000011));
        KEY_MAP.put("F9", new Integer(0x1000012));
        KEY_MAP.put("F10", new Integer(0x1000013));
        KEY_MAP.put("F11", new Integer(0x1000014));
        KEY_MAP.put("F12", new Integer(0x1000015));
        KEY_MAP.put("HOME", new Integer(0x1000007));
        KEY_MAP.put("END", new Integer(0x1000008));
        KEY_MAP.put("INSERT", new Integer(0x1000009));
        KEY_MAP.put("DELETE", new Integer(127));
        KEY_MAP.put("PAGE_UP", new Integer(0x1000005));
        KEY_MAP.put("PAGE_DOWN", new Integer(0x1000006));
        KEY_MAP.put("DOWN", new Integer(0x1000002));
        KEY_MAP.put("UP", new Integer(0x1000001));
        KEY_MAP.put("LEFT", new Integer(0x1000003));
        KEY_MAP.put("RIGHT", new Integer(0x1000004));
        KEY_MAP.put("NUMPAD_0", new Integer(0x1000030));
        KEY_MAP.put("NUMPAD_1", new Integer(0x1000031));
        KEY_MAP.put("NUMPAD_2", new Integer(16777266));
        KEY_MAP.put("NUMPAD_3", new Integer(0x1000033));
        KEY_MAP.put("NUMPAD_4", new Integer(16777268));
        KEY_MAP.put("NUMPAD_5", new Integer(16777269));
        KEY_MAP.put("NUMPAD_6", new Integer(16777270));
        KEY_MAP.put("NUMPAD_7", new Integer(16777271));
        KEY_MAP.put("NUMPAD_8", new Integer(16777272));
        KEY_MAP.put("NUMPAD_9", new Integer(16777273));
        MOD_MAP = new HashMap<String, Integer>();
        MOD_MAP.put("SHIFT", new Integer(131072));
        MOD_MAP.put("CTRL", new Integer(262144));
        MOD_MAP.put("ALT", new Integer(65536));
        KEYCODE_MAP = new HashMap<Integer, String>();
        int swtSpace = 32;
        KEYCODE_MAP.put(new Integer(13), new String("ENTER"));
        KEYCODE_MAP.put(new Integer(0x1000050), new String("ENTER"));
        KEYCODE_MAP.put(new Integer(swtSpace), new String("SPACE"));
        KEYCODE_MAP.put(new Integer(8), new String("BACK_SPACE"));
        KEYCODE_MAP.put(new Integer(9), new String("TAB"));
        KEYCODE_MAP.put(new Integer(27), new String("ESCAPE"));
        KEYCODE_MAP.put(new Integer(0x1000008), new String("END"));
        KEYCODE_MAP.put(new Integer(0x1000007), new String("HOME"));
        KEYCODE_MAP.put(new Integer(0x1000009), new String("INSERT"));
        KEYCODE_MAP.put(new Integer(127), new String("DELETE"));
        KEYCODE_MAP.put(new Integer(0x1000001), new String("UP"));
        KEYCODE_MAP.put(new Integer(0x1000002), new String("DOWN"));
        KEYCODE_MAP.put(new Integer(0x1000003), new String("LEFT"));
        KEYCODE_MAP.put(new Integer(0x1000004), new String("RIGHT"));
        KEYCODE_MAP.put(new Integer(0x1000005), new String("PAGE_UP"));
        KEYCODE_MAP.put(new Integer(0x1000006), new String("PAGE_DOWN"));
        KEYCODE_MAP.put(new Integer(0x100000A), new String("F1"));
        KEYCODE_MAP.put(new Integer(0x100000B), new String("F2"));
        KEYCODE_MAP.put(new Integer(0x100000C), new String("F3"));
        KEYCODE_MAP.put(new Integer(0x100000D), new String("F4"));
        KEYCODE_MAP.put(new Integer(0x100000E), new String("F5"));
        KEYCODE_MAP.put(new Integer(0x100000F), new String("F6"));
        KEYCODE_MAP.put(new Integer(0x1000010), new String("F7"));
        KEYCODE_MAP.put(new Integer(0x1000011), new String("F8"));
        KEYCODE_MAP.put(new Integer(0x1000012), new String("F9"));
        KEYCODE_MAP.put(new Integer(0x1000013), new String("F10"));
        KEYCODE_MAP.put(new Integer(0x1000014), new String("F11"));
        KEYCODE_MAP.put(new Integer(0x1000015), new String("F12"));
        KEYCODE_MAP.put(new Integer(0x1000030), new String("NUMPAD0"));
        KEYCODE_MAP.put(new Integer(0x1000031), new String("NUMPAD1"));
        KEYCODE_MAP.put(new Integer(16777266), new String("NUMPAD2"));
        KEYCODE_MAP.put(new Integer(0x1000033), new String("NUMPAD3"));
        KEYCODE_MAP.put(new Integer(16777268), new String("NUMPAD4"));
        KEYCODE_MAP.put(new Integer(16777269), new String("NUMPAD5"));
        KEYCODE_MAP.put(new Integer(16777270), new String("NUMPAD6"));
        KEYCODE_MAP.put(new Integer(16777271), new String("NUMPAD7"));
        KEYCODE_MAP.put(new Integer(16777272), new String("NUMPAD8"));
        KEYCODE_MAP.put(new Integer(16777273), new String("NUMPAD9"));
        KEYCODE_MAP.put(new Integer(16777259), new String("ADD"));
        KEYCODE_MAP.put(new Integer(16777263), new String("DIVIDE"));
        KEYCODE_MAP.put(new Integer(16777258), new String("MULTIPLY"));
        KEYCODE_MAP.put(new Integer(16777261), new String("SUBTRACT"));
        KEYCODE_MAP.put(new Integer(16777262), new String("DECIMAL"));
        KEYCODE_MAP.put(new Integer(16777299), new String("NUM_LOCK"));
        KEYCODE_MAP.put(new Integer(16777300), new String("SCROLL_LOCK"));
        KEYCODE_MAP.put(new Integer(0x1000055), new String("PAUSE"));
        KEYCODE_MAP.put(new Integer(16777303), new String("PRINT_SCREEN"));
        KEYCODE_MAP.put(new Integer(16777298), new String("CAPS_LOCK"));
        MODIFIER_MAP = new HashMap<Integer, String>();
        MODIFIER_MAP.put(new Integer(131072), new String("shift"));
        MODIFIER_MAP.put(new Integer(65536), new String("alt"));
        MODIFIER_MAP.put(new Integer(262144), new String("control"));
        MODIFIER_MAP.put(new Integer(393216), new String("control shift"));
        MODIFIER_MAP.put(new Integer(327680), new String("control alt"));
    }

    private SwtKeyCodeConverter() {
    }

    public static int getKeyCode(String keyCodeName) throws StepExecutionException {
        int code;
        int n = code = KEY_MAP.containsKey(keyCodeName) ? KEY_MAP.get(keyCodeName) : -1;
        if (code == -1 && log.isInfoEnabled()) {
            log.info((Object)("The key expression '" + keyCodeName + "' is not a key code. Returning -1."));
        }
        return code;
    }

    public static int getModifierCode(String modifierName) throws StepExecutionException {
        int code;
        int n = code = MOD_MAP.containsKey(modifierName) ? MOD_MAP.get(modifierName) : -1;
        if (code == -1 && log.isInfoEnabled()) {
            log.info((Object)("The key expression '" + modifierName + "' is not a modifier. Returning -1."));
        }
        return code;
    }

    public static String getKeyName(int keycode) throws StepExecutionException {
        String keyname;
        String string = keyname = KEYCODE_MAP.containsKey(new Integer(keycode)) ? KEYCODE_MAP.get(new Integer(keycode)) : null;
        if (keyname == null && log.isInfoEnabled()) {
            log.info((Object)("The keycode '" + keycode + "' is not a key expression. Returning null."));
        }
        return keyname;
    }

    public static String getModifierName(int modifier) throws StepExecutionException {
        String modname;
        String string = modname = MODIFIER_MAP.containsKey(new Integer(modifier)) ? MODIFIER_MAP.get(new Integer(modifier)) : null;
        if (modname == null && log.isInfoEnabled()) {
            log.info((Object)("The keycode '" + modifier + "' is not a key expression. Returning null."));
        }
        return modname;
    }

    public static Character getKeyChar(String keyCharName) throws StepExecutionException {
        Character character = CHAR_MAP.containsKey(keyCharName) ? CHAR_MAP.get(keyCharName) : new Character(keyCharName.charAt(0));
        return character;
    }
}

