/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.components;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.eclipse.jubula.rc.javafx.tester.util.compatibility.WindowsUtil;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentStages {
    public static final String JUBULA_FX_POLLING_RATE = "JUBULA_FX_POLLING_RATE";
    public static final String JUBULA_FX_WAIT_BEFORE_INIT = "JUBULA_FX_WAIT_BEFORE_INIT";
    private static final Logger LOG = LoggerFactory.getLogger(CurrentStages.class);
    private static ObservableList<Window> windows = FXCollections.observableArrayList();

    static {
        String pollingEnvString = EnvironmentUtils.getProcessOrSystemProperty((String)JUBULA_FX_POLLING_RATE);
        long pollingRate = 50L;
        if (pollingEnvString != null) {
            try {
                pollingRate = Long.parseLong(pollingEnvString);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.info("Could not convert the value.using standard polling rate " + pollingRate + "ms");
            }
        }
        String waitEnvString = EnvironmentUtils.getProcessOrSystemProperty((String)JUBULA_FX_WAIT_BEFORE_INIT);
        long waitTimeInMs = 0L;
        if (waitEnvString != null) {
            waitTimeInMs = 2000L;
            try {
                waitTimeInMs = Integer.parseInt(waitEnvString);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.info("Could not convert the value.using standard wait time " + waitTimeInMs + "ms");
            }
        }
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        Runnable windowCheck = new Runnable(){

            @Override
            public void run() {
                Window w;
                ListIterator it = WindowsUtil.getWindowIterator();
                ArrayList<Window> tempWin = new ArrayList<Window>();
                while (it.hasNext()) {
                    w = it.next();
                    tempWin.add(w);
                    if (windows.contains((Object)w)) continue;
                    windows.add((Object)w);
                }
                it = windows.listIterator();
                while (it.hasNext()) {
                    w = (Window)it.next();
                    if (tempWin.contains(w)) continue;
                    it.remove();
                }
            }
        };
        scheduler.scheduleAtFixedRate(windowCheck, waitTimeInMs, pollingRate, TimeUnit.MILLISECONDS);
    }

    private CurrentStages() {
    }

    public static Window getfirstStage() {
        for (Window window : windows) {
            if (!(window instanceof Stage)) continue;
            return window;
        }
        return null;
    }

    public static List<Window> getWindowList() {
        return windows;
    }

    public static Window getfocusStage() {
        Window fStage = null;
        for (Window win : windows) {
            if (!win.isFocused() || !(win instanceof Stage)) continue;
            fStage = win;
        }
        return fStage;
    }

    public static void addStagesListener(ListChangeListener<Window> listener) {
        windows.addListener(listener);
    }

    public static void removeStagesListener(ListChangeListener<Window> listener) {
        windows.removeListener(listener);
    }
}

