/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.ui.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.server.tomcat.ui.internal.CleanWorkDirDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;

public class CleanWorkDirAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private IServer selectedServer;
    private IModule selectedModule;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        CleanWorkDirDialog dlg = new CleanWorkDirDialog(this.targetPart.getSite().getShell(), this.selectedServer, this.selectedModule);
        dlg.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedServer = null;
        this.selectedModule = null;
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof IServer) {
                this.selectedServer = (IServer)obj;
            } else if (obj instanceof IServerModule) {
                IServerModule sm = (IServerModule)obj;
                IModule[] module = sm.getModule();
                this.selectedModule = module[module.length - 1];
                if (this.selectedModule != null) {
                    this.selectedServer = sm.getServer();
                }
            }
        }
    }
}

