/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.PauseTransition;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.gestures.AbstractGesture;
import org.eclipse.gef.mvc.fx.handlers.IOnHoverHandler;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class HoverGesture
extends AbstractGesture {
    public static final long HOVER_INTENT_MILLIS = 250L;
    public static final double HOVER_INTENT_MOUSE_MOVE_THRESHOLD = 4.0;
    public static final Class<IOnHoverHandler> ON_HOVER_POLICY_KEY = IOnHoverHandler.class;
    private final Map<Scene, EventHandler<MouseEvent>> hoverFilters = new IdentityHashMap<Scene, EventHandler<MouseEvent>>();
    private Point hoverIntentScreenPosition;
    private PauseTransition hoverIntentDelay = new PauseTransition(Duration.millis((double)this.getHoverIntentMillis()));
    private Node hoverIntent;
    private Node potentialHoverIntent;

    public HoverGesture() {
        this.hoverIntentDelay.setOnFinished(ae -> this.onHoverIntentDelayFinished());
    }

    protected EventHandler<MouseEvent> createHoverFilter() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                HoverGesture.this.updateHoverIntentPosition(event);
                if (!HoverGesture.this.isHoverEvent(event)) {
                    return;
                }
                EventTarget eventTarget = event.getTarget();
                if (eventTarget instanceof Node) {
                    IViewer viewer = PartUtils.retrieveViewer(HoverGesture.this.getDomain(), (Node)eventTarget);
                    if (viewer != null) {
                        HoverGesture.this.notifyHover(viewer, event, (Node)eventTarget);
                    }
                    HoverGesture.this.updateHoverIntent(event, (Node)eventTarget);
                }
            }
        };
    }

    @Override
    protected void doDeactivate() {
        this.hoverIntentDelay.stop();
        super.doDeactivate();
    }

    @Override
    protected void doHookScene(Scene scene) {
        EventHandler<MouseEvent> hoverFilter = this.createHoverFilter();
        scene.addEventFilter(MouseEvent.ANY, hoverFilter);
        this.hoverFilters.put(scene, hoverFilter);
    }

    @Override
    protected void doUnhookScene(Scene scene) {
        scene.removeEventFilter(MouseEvent.ANY, this.hoverFilters.remove(scene));
    }

    protected long getHoverIntentMillis() {
        return 250L;
    }

    protected double getHoverIntentMouseMoveThreshold() {
        return 4.0;
    }

    protected boolean isHoverEvent(MouseEvent event) {
        return event.getEventType().equals(MouseEvent.MOUSE_MOVED) || event.getEventType().equals(MouseEvent.MOUSE_ENTERED_TARGET) || event.getEventType().equals(MouseEvent.MOUSE_EXITED_TARGET);
    }

    protected void notifyHover(IViewer viewer, MouseEvent event, Node eventTarget) {
        List<IOnHoverHandler> policies = this.getHandlerResolver().resolve(this, eventTarget, viewer, ON_HOVER_POLICY_KEY);
        this.getDomain().openExecutionTransaction(this);
        for (IOnHoverHandler policy : policies) {
            policy.hover(event);
        }
        this.getDomain().closeExecutionTransaction(this);
    }

    protected void notifyHoverIntent(IViewer viewer, Node hoverIntent) {
        List<IOnHoverHandler> policies = this.getHandlerResolver().resolve(this, hoverIntent, viewer, ON_HOVER_POLICY_KEY);
        this.getDomain().openExecutionTransaction(this);
        for (IOnHoverHandler policy : policies) {
            policy.hoverIntent(hoverIntent);
        }
        this.getDomain().closeExecutionTransaction(this);
    }

    private void onHoverIntentDelayFinished() {
        this.hoverIntent = this.potentialHoverIntent;
        this.potentialHoverIntent = null;
        IViewer viewer = PartUtils.retrieveViewer(this.getDomain(), this.hoverIntent);
        if (viewer != null) {
            this.notifyHoverIntent(viewer, this.hoverIntent);
        }
    }

    private void updateHoverIntent(MouseEvent event, Node eventTarget) {
        if (eventTarget != this.hoverIntent) {
            this.potentialHoverIntent = eventTarget;
            this.hoverIntentScreenPosition = new Point(event.getScreenX(), event.getScreenY());
            this.hoverIntentDelay.playFromStart();
        } else {
            this.hoverIntentDelay.stop();
        }
    }

    private void updateHoverIntentPosition(MouseEvent event) {
        if (this.hoverIntentDelay.getStatus().equals((Object)Animation.Status.RUNNING)) {
            double dx = this.hoverIntentScreenPosition.x - event.getScreenX();
            double dy = this.hoverIntentScreenPosition.y - event.getScreenY();
            double threshold = this.getHoverIntentMouseMoveThreshold();
            if (Math.abs(dx) > threshold || Math.abs(dy) > threshold) {
                this.hoverIntentDelay.playFromStart();
                this.hoverIntentScreenPosition.x = event.getScreenX();
                this.hoverIntentScreenPosition.y = event.getScreenY();
            }
        }
    }
}

