/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;

public class DotHtmlLabelLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    public DotHtmlLabelLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    String image(HtmlTag htmlTag) {
        return "html_tag.png";
    }

    String image(HtmlAttr htmlAttr) {
        return "attribute.png";
    }

    String image(HtmlContent htmlContent) {
        return "html_text.png";
    }

    Object text(HtmlTag htmlTag) {
        String format = htmlTag.isSelfClosing() ? "<%s/>: Tag" : "<%s>: Tag";
        return DotEditorUtils.style(format, htmlTag.getName());
    }

    Object text(HtmlAttr htmlAttr) {
        String format = "%s = %s: Attribute";
        return DotEditorUtils.style(format, htmlAttr.getName(), htmlAttr.getValue());
    }

    Object text(HtmlContent htmlContent) {
        String format = "%s: Text";
        String text = htmlContent.getText() == null ? "" : htmlContent.getText().trim();
        return DotEditorUtils.style(format, text);
    }
}

