/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import static org.apache.commons.lang3.StringUtils.defaultString;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

class ProjectsFormat extends Format {

    private final Map<String, String> args;

    ProjectsFormat(Map<String, String> args) {
        this.args = args;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        Collection<IServerDescriptor> servers = (Collection<IServerDescriptor>) obj;
        switch (defaultString(args.get("style")).toLowerCase()) { //$NON-NLS-1$
        case "numbers": //$NON-NLS-1$
            return handleNumbers(toAppendTo, servers);
        case "long": //$NON-NLS-1$
            return handleLong(toAppendTo, servers);
        case "short": //$NON-NLS-1$
            return handleMedium(toAppendTo, servers);
        case "": //$NON-NLS-1$
        default:
        }
        return toAppendTo;
    }

    private StringBuffer handleMedium(StringBuffer sb, Collection<IServerDescriptor> servers) {
        int size = servers.size();
        switch (size) {
        case 0:
            return sb.append(Messages.FORMATTING_ZERO_PROJECTS);
        case 1:
            return sb.append(Iterables.get(servers, 0).getName());
        default:
            sb.append(Iterables.get(servers, 0).getName());
            return sb.append(Formats.format(Messages.FORMATTING_MORE_PROJECTS, size - 1));
        }
    }

    private StringBuffer handleLong(StringBuffer sb, Collection<IServerDescriptor> servers) {
        int size = servers.size();
        if (size == 1) {
            return sb.append(Iterables.get(servers, 0).getName());
        }
        LinkedList<IServerDescriptor> cp = Lists.newLinkedList(servers);
        sb.append(Joiner.on(Messages.FORMATTING_LIST_SEPARATOR).join(cp.subList(0, size - 2)));
        return sb.append(Messages.FORMATTING_LIST_SEPARATOR_LAST).append(Iterables.getLast(cp).getName());
    }

    private StringBuffer handleNumbers(StringBuffer toAppendTo, Collection<IServerDescriptor> servers) {
        switch (servers.size()) {
        case 0:
            return toAppendTo.append(Messages.FORMATTING_ZERO_PROJECTS);
        case 1:
            return toAppendTo.append(Messages.FORMATTING_ONE_PROJECT);
        case 2:
            return toAppendTo.append(Messages.FORMATTING_TWO_PROJECTS);
        case 3:
            return toAppendTo.append(Messages.FORMATTING_THREE_PROJECTS);
        default:
            return toAppendTo.append(Formats.format(Messages.FORMATTING_X_PROJECTS, servers.size()));
        }
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

}
