/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.util;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.client.ui.util.EMFStoreFileDialogHelper;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileDialogHelper {
    private static final String EMFSTORE_CLIENT_UI_PLUGIN_ID = "org.eclipse.emf.emfstore.client.ui";
    private static final String FILE_DIALOG_HELPER_CLASS = "org.eclipse.emf.emfstore.internal.client.ui.util.EMFStoreFileDialogHelperImpl";

    private FileDialogHelper() {
    }

    public static String openExportDialog(Shell shell, String fileName) {
        return FileDialogHelper.getFilePathByFileDialog(shell, true, fileName);
    }

    public static String openImportDialog(Shell shell) {
        return FileDialogHelper.getFilePathByFileDialog(shell, false, null);
    }

    private static String getFilePathByFileDialog(Shell shell, boolean isExport, String fileName) {
        try {
            Class clazz = FileDialogHelper.loadClass(EMFSTORE_CLIENT_UI_PLUGIN_ID, FILE_DIALOG_HELPER_CLASS);
            EMFStoreFileDialogHelper fileDialogHelper = (EMFStoreFileDialogHelper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (isExport) {
                return fileDialogHelper.getPathForExport(shell, fileName);
            }
            return fileDialogHelper.getPathForImport(shell);
        }
        catch (ClassNotFoundException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (InstantiationException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (IllegalArgumentException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        catch (SecurityException ex) {
            WorkspaceUtil.logException((String)ex.getMessage(), (Exception)ex);
        }
        return null;
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + " cannot be loaded because bundle " + bundleName + " cannot be resolved");
        }
        return bundle.loadClass(clazz);
    }
}

