/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.action;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecoretools.design.ui.wizard.InitializeEcoreDiagramWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class EcoreInitDiagramFileAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private Collection<URI> domainModelURI = Lists.newArrayList();
    private IProject containingProject;
    private IStructuredSelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.domainModelURI.clear();
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        this.selection = (IStructuredSelection)selection;
        if (this.selection.getFirstElement() instanceof IFile) {
            IFile file = (IFile)this.selection.getFirstElement();
            this.containingProject = file.getProject();
            this.domainModelURI.add(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
            action.setEnabled(true);
            IFile genmodel = this.containingProject.getFile(file.getProjectRelativePath().removeFileExtension().addFileExtension("genmodel"));
            if (genmodel.exists() && genmodel.isAccessible()) {
                this.domainModelURI.add(URI.createPlatformResourceURI((String)genmodel.getFullPath().toString(), (boolean)true));
            }
        }
    }

    private Shell getShell() {
        return this.targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        this.openCreateRepresentationWizard();
    }

    protected void openCreateRepresentationWizard() {
        InitializeEcoreDiagramWizard wizard = new InitializeEcoreDiagramWizard(this.selection, this.domainModelURI, this.containingProject);
        wizard.init();
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.setPageSize(750, 400);
        dialog.create();
        dialog.getShell().setText("Create Representation Wizard");
        dialog.open();
    }
}

