/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLobUtil;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.AbstractTypeMapping;
import org.eclipse.emf.cdo.server.db.mapping.AbstractTypeMappingFactory;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMappingUtil;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class CoreTypeMappings {
    public static final String ID_PREFIX = "org.eclipse.emf.cdo.server.db.CoreTypeMappings";

    public static class TMBigDecimal
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BigDecimal", (EClassifier)EcorePackage.eINSTANCE.getEBigDecimal(), DBType.VARCHAR));
        public static final Factory FACTORY_LONG_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BigDecimalLongVarchar", (EClassifier)EcorePackage.eINSTANCE.getEBigDecimal(), DBType.LONGVARCHAR));

        @Override
        protected Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String val = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return new BigDecimal(val);
        }

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((BigDecimal)value).toPlainString());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMBigDecimal();
            }
        }
    }

    public static class TMBigInteger
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BigInteger", (EClassifier)EcorePackage.eINSTANCE.getEBigInteger(), DBType.VARCHAR));
        public static final Factory FACTORY_LONG_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BigIntegerLongVarChar", (EClassifier)EcorePackage.eINSTANCE.getEBigInteger(), DBType.LONGVARCHAR));

        @Override
        protected Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String val = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return new BigInteger(val);
        }

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((BigInteger)value).toString());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMBigInteger();
            }
        }
    }

    public static class TMBlob
    extends AbstractTypeMapping {
        public static final Factory FACTORY_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BlobStream", (EClassifier)EtypesPackage.eINSTANCE.getBlob(), DBType.VARCHAR));
        public static final Factory FACTORY_LONG_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BlobStreamLongVarchar", (EClassifier)EtypesPackage.eINSTANCE.getBlob(), DBType.LONGVARCHAR));

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            CDOBlob blob = (CDOBlob)value;
            stmt.setString(index, String.valueOf(HexUtil.bytesToHex((byte[])blob.getID())) + "-" + blob.getSize());
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String str = resultSet.getString(this.getField().getName());
            if (str == null) {
                return null;
            }
            int pos = str.indexOf(45);
            byte[] id = HexUtil.hexToBytes((String)str.substring(0, pos));
            long size = Long.parseLong(str.substring(pos + 1));
            return CDOLobUtil.createBlob((byte[])id, (long)size);
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMBlob();
            }
        }
    }

    public static class TMBoolean
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Boolean", (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), DBType.BOOLEAN));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BooleanObject", (EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), DBType.BOOLEAN));
        public static final Factory FACTORY_SMALLINT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Boolean_SMALLINT", (EClassifier)EcorePackage.eINSTANCE.getEBoolean(), DBType.SMALLINT));
        public static final Factory FACTORY_OBJECT_SMALLINT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.BooleanObject_SMALLINT", (EClassifier)EcorePackage.eINSTANCE.getEBooleanObject(), DBType.SMALLINT));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getBoolean(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMBoolean();
            }
        }
    }

    public static class TMByte
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Byte", (EClassifier)EcorePackage.eINSTANCE.getEByte(), DBType.SMALLINT));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.ByteObject", (EClassifier)EcorePackage.eINSTANCE.getEByteObject(), DBType.SMALLINT));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getByte(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMByte();
            }
        }
    }

    public static class TMBytes
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.ByteArray", (EClassifier)EcorePackage.eINSTANCE.getEByteArray(), DBType.BLOB));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getBytes(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMBytes();
            }
        }
    }

    public static class TMBytesVarbinary
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.ByteArrayVarbinary", (EClassifier)EcorePackage.eINSTANCE.getEByteArray(), DBType.VARBINARY));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getBytes(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMBytesVarbinary();
            }
        }
    }

    public static class TMCharacter
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Character", (EClassifier)EcorePackage.eINSTANCE.getEChar(), DBType.CHAR));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.CharacterObject", (EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), DBType.CHAR));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String str = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            if (str.length() == 0) {
                return Character.valueOf(' ');
            }
            return Character.valueOf(str.charAt(0));
        }

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setString(index, ((Character)value).toString());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMCharacter();
            }
        }
    }

    public static class TMCharacter2Integer
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Character2Integer", (EClassifier)EcorePackage.eINSTANCE.getEChar(), DBType.INTEGER));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.CharacterObject2Integer", (EClassifier)EcorePackage.eINSTANCE.getECharacterObject(), DBType.INTEGER));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            int intRepresentation = resultSet.getInt(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return Character.valueOf((char)intRepresentation);
        }

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setInt(index, ((Character)value).charValue());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMCharacter2Integer();
            }
        }
    }

    public static class TMClob
    extends AbstractTypeMapping {
        public static final Factory FACTORY_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.ClobStream", (EClassifier)EtypesPackage.eINSTANCE.getClob(), DBType.VARCHAR));
        public static final Factory FACTORY_LONG_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.ClobStreamLongVarchar", (EClassifier)EtypesPackage.eINSTANCE.getClob(), DBType.LONGVARCHAR));

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            CDOClob clob = (CDOClob)value;
            stmt.setString(index, String.valueOf(HexUtil.bytesToHex((byte[])clob.getID())) + "-" + clob.getSize());
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String str = resultSet.getString(this.getField().getName());
            if (str == null) {
                return null;
            }
            int pos = str.indexOf(45);
            byte[] id = HexUtil.hexToBytes((String)str.substring(0, pos));
            long size = Long.parseLong(str.substring(pos + 1));
            return CDOLobUtil.createClob((byte[])id, (long)size);
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMClob();
            }
        }
    }

    public static class TMCustom
    extends AbstractTypeMapping {
        public static final Factory FACTORY_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.CustomVarchar", (EClassifier)EcorePackage.eINSTANCE.getEDataType(), DBType.VARCHAR));
        public static final Factory FACTORY_LONG_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.CustomLongVarchar", (EClassifier)EcorePackage.eINSTANCE.getEDataType(), DBType.LONGVARCHAR));
        public static final Factory FACTORY_CLOB = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.CustomClob", (EClassifier)EcorePackage.eINSTANCE.getEDataType(), DBType.CLOB));

        @Override
        protected Object getResultSetValue(ResultSet resultSet) throws SQLException {
            String val = resultSet.getString(this.getField().getName());
            if (resultSet.wasNull()) {
                return this.getFeature().isUnsettable() ? CDORevisionData.NIL : null;
            }
            return val;
        }

        @Override
        protected Object getDefaultValue() {
            Object defaultValue = this.getFeature().getDefaultValue();
            if (defaultValue == null) {
                return null;
            }
            EFactory factory = this.getFeature().getEType().getEPackage().getEFactoryInstance();
            return factory.convertToString((EDataType)this.getFeature().getEType(), defaultValue);
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMCustom();
            }
        }
    }

    public static class TMDate2Date
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Date", (EClassifier)EcorePackage.eINSTANCE.getEDate(), DBType.DATE));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getDate(this.getField().getName(), Calendar.getInstance());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMDate2Date();
            }
        }
    }

    public static class TMDate2Time
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Time", (EClassifier)EcorePackage.eINSTANCE.getEDate(), DBType.TIME));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getTime(this.getField().getName(), Calendar.getInstance());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMDate2Time();
            }
        }
    }

    public static class TMDate2Timestamp
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Timestamp", (EClassifier)EcorePackage.eINSTANCE.getEDate(), DBType.TIMESTAMP));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getTimestamp(this.getField().getName());
        }

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            stmt.setTimestamp(index, new Timestamp(((Date)value).getTime()));
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMDate2Timestamp();
            }
        }
    }

    public static class TMDouble
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Double", (EClassifier)EcorePackage.eINSTANCE.getEDouble(), DBType.DOUBLE));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.DoubleObject", (EClassifier)EcorePackage.eINSTANCE.getEDoubleObject(), DBType.DOUBLE));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getDouble(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMDouble();
            }
        }
    }

    public static class TMEnum
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Enum", (EClassifier)EcorePackage.eINSTANCE.getEEnum(), DBType.INTEGER));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getInt(this.getField().getName());
        }

        @Override
        protected Object getDefaultValue() {
            EEnum eenum = (EEnum)this.getFeature().getEType();
            String defaultValueLiteral = this.getFeature().getDefaultValueLiteral();
            if (defaultValueLiteral != null) {
                EEnumLiteral literal = eenum.getEEnumLiteralByLiteral(defaultValueLiteral);
                return literal.getValue();
            }
            Enumerator enumerator = (Enumerator)eenum.getDefaultValue();
            return enumerator.getValue();
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMEnum();
            }
        }
    }

    public static class TMFloat
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Float", (EClassifier)EcorePackage.eINSTANCE.getEFloat(), DBType.FLOAT));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.FloatObject", (EClassifier)EcorePackage.eINSTANCE.getEFloatObject(), DBType.FLOAT));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return Float.valueOf(resultSet.getFloat(this.getField().getName()));
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMFloat();
            }
        }
    }

    public static class TMInteger
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Integer", (EClassifier)EcorePackage.eINSTANCE.getEInt(), DBType.INTEGER));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.IntegerObject", (EClassifier)EcorePackage.eINSTANCE.getEIntegerObject(), DBType.INTEGER));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getInt(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMInteger();
            }
        }
    }

    public static class TMJavaClass
    extends AbstractTypeMapping {
        public static final Factory FACTORY_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.JavaClassVarchar", (EClassifier)EcorePackage.eINSTANCE.getEJavaClass(), DBType.VARCHAR));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getString(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMJavaClass();
            }
        }
    }

    public static class TMJavaObject
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.JavaObjectBlob", (EClassifier)EcorePackage.eINSTANCE.getEJavaObject(), DBType.BLOB));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getBytes(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMJavaObject();
            }
        }
    }

    public static class TMLong
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Long", (EClassifier)EcorePackage.eINSTANCE.getELong(), DBType.BIGINT));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.LongObject", (EClassifier)EcorePackage.eINSTANCE.getELongObject(), DBType.BIGINT));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getLong(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMLong();
            }
        }
    }

    public static class TMObject
    extends AbstractTypeMapping {
        @Override
        protected int getDBLength(DBType type) {
            return this.getMappingStrategy().getStore().getIDColumnLength();
        }

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
            CDOID id = idHandler.getCDOID(resultSet, this.getField().getName());
            if (id == null && this.getFeature().isUnsettable()) {
                return CDORevisionData.NIL;
            }
            return id;
        }

        @Override
        protected void doSetValue(PreparedStatement stmt, int index, Object value) throws SQLException {
            IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
            idHandler.setCDOID(stmt, index, (CDOID)value);
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMObject();
            }
        }
    }

    public static class TMShort
    extends AbstractTypeMapping {
        public static final Factory FACTORY = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.Short", (EClassifier)EcorePackage.eINSTANCE.getEShort(), DBType.SMALLINT));
        public static final Factory FACTORY_OBJECT = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.ShortObject", (EClassifier)EcorePackage.eINSTANCE.getEShortObject(), DBType.SMALLINT));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getShort(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMShort();
            }
        }
    }

    public static class TMString
    extends AbstractTypeMapping {
        public static final Factory FACTORY_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.StringVarchar", (EClassifier)EcorePackage.eINSTANCE.getEString(), DBType.VARCHAR));
        public static final Factory FACTORY_LONG_VARCHAR = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.StringLongVarchar", (EClassifier)EcorePackage.eINSTANCE.getEString(), DBType.LONGVARCHAR));
        public static final Factory FACTORY_CLOB = new Factory(TypeMappingUtil.createDescriptor("org.eclipse.emf.cdo.server.db.CoreTypeMappings.StringClob", (EClassifier)EcorePackage.eINSTANCE.getEString(), DBType.CLOB));

        @Override
        public Object getResultSetValue(ResultSet resultSet) throws SQLException {
            return resultSet.getString(this.getField().getName());
        }

        public static class Factory
        extends AbstractTypeMappingFactory {
            public Factory(ITypeMapping.Descriptor descriptor) {
                super(descriptor);
            }

            @Override
            public ITypeMapping create(String description) throws ProductCreationException {
                return new TMString();
            }
        }
    }
}

