/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.lob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.cdo.common.lob.CDOBlob;

public class CDOBlobOutputStream
extends OutputStream {
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private CDOBlob blob;

    @Override
    public void write(int b) throws IOException {
        this.checkBuffer();
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkBuffer();
        this.buffer.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            this.blob = new CDOBlob(new ByteArrayInputStream(this.buffer.toByteArray()));
            this.buffer = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.checkBuffer();
        this.buffer.flush();
    }

    public CDOBlob getBlob() {
        return this.blob;
    }

    void checkBuffer() throws IOException {
        if (this.buffer == null) {
            throw new IOException("CDOBlobOutputStream closed");
        }
    }
}

