/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifier;
import org.eclipse.dltk.internal.corext.buildpath.BuildpathModifierOperation;
import org.eclipse.dltk.internal.corext.buildpath.IBuildpathInformationProvider;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;

public class AddSelectedSourceFolderOperation
extends BuildpathModifierOperation {
    public AddSelectedSourceFolderOperation(BuildpathModifier.IBuildpathModifierListener listener, IBuildpathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip, 0);
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            List elements = this.getSelectedElements();
            IScriptProject project = this.fInformationProvider.getScriptProject();
            result = this.addToBuildpath(elements, project, monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    @Override
    public boolean isValid(List elements, int[] types) throws ModelException {
        if (elements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < elements.size()) {
            Object object = elements.get(i);
            switch (types[i]) {
                case 1: {
                    if (!AddSelectedSourceFolderOperation.isSourceFolder((IScriptProject)object)) break;
                    return false;
                }
                case 3: {
                    break;
                }
                case 11: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getDescription(int type) {
        Object obj = this.getSelectedElements().get(0);
        if (obj instanceof IModelElement) {
            String name = AddSelectedSourceFolderOperation.escapeSpecialChars(((IModelElement)obj).getElementName());
            if (type == 1) {
                return MessageFormat.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectToBuildpath, name);
            }
            if (type == 3) {
                return MessageFormat.format(NewWizardMessages.PackageExplorerActionGroup_FormText_PackageToBuildpath, name);
            }
            if (type == 14) {
                return MessageFormat.format(NewWizardMessages.PackageExplorerActionGroup_FormText_PackageToBuildpath, name);
            }
        } else if (obj instanceof IResource) {
            String name = AddSelectedSourceFolderOperation.escapeSpecialChars(((IResource)obj).getName());
            if (type == 6) {
                return MessageFormat.format(NewWizardMessages.PackageExplorerActionGroup_FormText_FolderToBuildpath, name);
            }
            if (type == 7) {
                return MessageFormat.format(NewWizardMessages.PackageExplorerActionGroup_FormText_FolderToBuildpath, name);
            }
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath;
    }
}

