/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.index.CDTIndex;
import org.eclipse.cdt.internal.qt.core.index.IQGadget;
import org.eclipse.cdt.internal.qt.core.index.IQObject;
import org.eclipse.cdt.internal.qt.core.index.IQmlRegistration;
import org.eclipse.cdt.internal.qt.core.index.QGadget;
import org.eclipse.cdt.internal.qt.core.index.QObject;
import org.eclipse.cdt.internal.qt.core.index.QmlRegistration;
import org.eclipse.cdt.internal.qt.core.index.QtIndex;
import org.eclipse.cdt.internal.qt.core.pdom.AbstractQtPDOMClass;
import org.eclipse.cdt.internal.qt.core.pdom.QtPDOMQObject;
import org.eclipse.core.runtime.CoreException;

public class QtIndexImpl
extends QtIndex {
    private final CDTIndex cdtIndex;
    private static final Pattern QmlTypeNameRegex = Pattern.compile("^(?:qmlRegisterType|qmlRegisterUncreatableType)<.*>\u0000(.*)$");
    private static final IndexFilter QtLinkageFilter = new IndexFilter(){

        public boolean acceptLinkage(ILinkage linkage) {
            return linkage.getLinkageID() == 5;
        }

        public boolean acceptBinding(IBinding binding) throws CoreException {
            return true;
        }
    };

    public QtIndexImpl(CDTIndex cdtIndex) {
        this.cdtIndex = cdtIndex;
    }

    @Override
    public IQObject findQObject(String[] name) {
        return name == null ? null : this.cdtIndex.get(new QObjectImplAccessor(name));
    }

    @Override
    public IQGadget findQGadget(String[] name) {
        return name == null ? null : this.cdtIndex.get(new QGadgetImplAccessor(name));
    }

    @Override
    public Collection<IQmlRegistration> getQmlRegistrations() {
        return this.cdtIndex.get(new QmlRegistrationAccessor());
    }

    private class QGadgetImplAccessor
    implements CDTIndex.Accessor<IQGadget> {
        private final char[][] name;

        public QGadgetImplAccessor(String[] qualName) {
            this.name = new char[qualName.length][];
            int i = 0;
            while (i < this.name.length) {
                this.name[i] = qualName[i].toCharArray();
                ++i;
            }
        }

        @Override
        public IQGadget access(IIndex index) throws CoreException {
            IIndexBinding[] iIndexBindingArray = index.findBindings(this.name, QtLinkageFilter, null);
            int n = iIndexBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexBinding binding = iIndexBindingArray[n2];
                if (binding instanceof AbstractQtPDOMClass) {
                    return new QGadget(QtIndexImpl.this, QtIndexImpl.this.cdtIndex, (AbstractQtPDOMClass)binding);
                }
                ++n2;
            }
            return null;
        }
    }

    private class QObjectImplAccessor
    implements CDTIndex.Accessor<IQObject> {
        private final char[] name;

        public QObjectImplAccessor(String[] qualName) {
            this.name = ASTUtil.getFullyQualifiedName(qualName).toCharArray();
        }

        @Override
        public IQObject access(IIndex index) throws CoreException {
            IIndexBinding[] iIndexBindingArray = index.findBindings(this.name, QtLinkageFilter, null);
            int n = iIndexBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexBinding binding = iIndexBindingArray[n2];
                if (binding instanceof QtPDOMQObject) {
                    return new QObject(QtIndexImpl.this, QtIndexImpl.this.cdtIndex, (QtPDOMQObject)binding);
                }
                ++n2;
            }
            return null;
        }
    }

    private class QmlRegistrationAccessor
    implements CDTIndex.Accessor<Collection<IQmlRegistration>> {
        private QmlRegistrationAccessor() {
        }

        @Override
        public Collection<IQmlRegistration> access(IIndex index) throws CoreException {
            ArrayList<QmlRegistration> types = null;
            IIndexBinding[] iIndexBindingArray = index.findBindings(QmlTypeNameRegex, false, QtLinkageFilter, null);
            int n = iIndexBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexBinding binding = iIndexBindingArray[n2];
                QmlRegistration qml = QmlRegistration.create(QtIndexImpl.this, (IBinding)binding);
                if (qml != null) {
                    if (types == null) {
                        types = new ArrayList<QmlRegistration>();
                    }
                    types.add(qml);
                }
                ++n2;
            }
            return types == null ? Collections.emptyList() : types;
        }
    }
}

