/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.debugsources;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.cdt.debug.internal.core.sourcelookup.ICSourceNotFoundDescription;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.CSourceNotFoundEditorInput;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesLabelProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesTreeContentProvider;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesTreeElement;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.DebugSourcesViewComparator;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.actions.DebugSourcesCollapseAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.actions.DebugSourcesExpandAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.actions.DebugSourcesFlattendedTree;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.actions.DebugSourcesNormalTree;
import org.eclipse.cdt.dsf.gdb.internal.ui.debugsources.actions.DebugSourcesShowExistingFilesOnly;
import org.eclipse.cdt.dsf.gdb.service.IDebugSourceFiles;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class DebugSourcesView
extends ViewPart
implements IDebugContextListener {
    public static final String ID = "org.eclipse.cdt.dsf.gdb.ui.debugsources.view";
    private static final String KEY_FLATTEN_FOLDERS_WITH_NO_FILES = "KEY_FLATTEN_FOLDERS_WITH_NO_FILES";
    private static final String KEY_SHOW_EXISTING_FILES_ONLY = "KEY_SHOW_EXISTING_FILES_ONLY";
    private DsfSession fSession;
    private TreeViewer viewer;
    private DebugSourcesViewComparator<DebugSourcesTreeElement> comparator;
    private IRunControl.IContainerDMContext dmcontext;
    private DebugSourcesTreeElement debugTree;
    private IMemento fMemento;
    private static final String POPULATE_FAMILY = "populateJobFamily";
    private static final String FILECHECK_FAMILY = "fileCheckJobFamily";

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        DebugPatternFilter filter = new DebugPatternFilter();
        int treeStyle = 68358;
        FilteredTree tree = new FilteredTree(composite, treeStyle, (PatternFilter)filter, true, true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        tree.getFilterControl().setToolTipText(DebugSourcesMessages.DebugSourcesMessages_filter_search_tooltip);
        this.viewer = tree.getViewer();
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new DebugSourcesTreeContentProvider());
        this.viewer.setUseHashlookup(true);
        this.comparator = new DebugSourcesViewComparator();
        this.createColumns(this.viewer);
        this.loadState();
        this.viewer.setComparator(this.comparator);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DebugSourcesTreeElement node;
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                if (selectedNode instanceof DebugSourcesTreeElement && !(node = (DebugSourcesTreeElement)selectedNode).hasChildren()) {
                    DebugSourcesView.this.openSourceFile(node.getFullPath());
                }
            }
        });
        this.createActions(this.viewer);
        this.registerForEvents();
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.fMemento = memento;
        super.init(site, memento);
    }

    public void loadState() {
        boolean flattenFoldersWithNoFiles = true;
        boolean showExistingFilesOnly = true;
        if (this.fMemento != null) {
            Boolean b = this.fMemento.getBoolean(KEY_FLATTEN_FOLDERS_WITH_NO_FILES);
            if (b != null) {
                flattenFoldersWithNoFiles = b;
            }
            if ((b = this.fMemento.getBoolean(KEY_SHOW_EXISTING_FILES_ONLY)) != null) {
                showExistingFilesOnly = b;
            }
        }
        if (this.viewer != null) {
            DebugSourcesTreeContentProvider contentProvider = (DebugSourcesTreeContentProvider)this.viewer.getContentProvider();
            contentProvider.setFlattenFoldersWithNoFiles(flattenFoldersWithNoFiles);
            contentProvider.setShowExistingFilesOnly(showExistingFilesOnly);
            int i = 0;
            while (i < this.viewer.getTree().getColumnCount()) {
                DebugSourcesLabelProvider labelProvider = (DebugSourcesLabelProvider)this.viewer.getLabelProvider(i);
                labelProvider.setFlattenFoldersWithNoFiles(flattenFoldersWithNoFiles);
                labelProvider.setShowExistingFilesOnly(showExistingFilesOnly);
                ++i;
            }
        }
    }

    public void saveState(IMemento memento) {
        DebugSourcesTreeContentProvider contentProvider = (DebugSourcesTreeContentProvider)this.viewer.getContentProvider();
        memento.putBoolean(KEY_FLATTEN_FOLDERS_WITH_NO_FILES, contentProvider.isFlattenFoldersWithNoFiles());
        memento.putBoolean(KEY_SHOW_EXISTING_FILES_ONLY, contentProvider.isShowExistingFilesOnly());
        super.saveState(memento);
    }

    private void createColumns(TreeViewer viewer) {
        String[] titles = new String[]{DebugSourcesMessages.DebugSourcesMessages_name_column, DebugSourcesMessages.DebugSourcesMessages_path_column};
        String[] tooltips = new String[]{DebugSourcesMessages.DebugSourcesMessages_sort_name_column_tooltip, DebugSourcesMessages.DebugSourcesMessages_sort_path_column_tooltip};
        int[] bounds = new int[]{300, 800};
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        int i = 0;
        while (i < titles.length) {
            TreeViewerColumn tc = this.createTreeViewerColumn(viewer, titles[i], bounds[i], i);
            tc.getColumn().setToolTipText(tooltips[i]);
            tc.setLabelProvider((CellLabelProvider)new DebugSourcesLabelProvider(i));
            ++i;
        }
    }

    private TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title, int bound, int colNumber) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        if (colNumber == 0) {
            this.comparator.setColumn(e -> e.getName(), colNumber);
        }
        if (colNumber == 1) {
            this.comparator.setColumn(e -> e.getFullPath() != null ? e.getFullPath() : e.getName(), colNumber);
        }
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
        return viewerColumn;
    }

    private SelectionAdapter getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (index == 0) {
                    DebugSourcesView.this.comparator.setColumn(e1 -> e1.getName(), index);
                }
                if (index == 1) {
                    DebugSourcesView.this.comparator.setColumn(e1 -> e1.getFullPath() != null ? e1.getFullPath() : e1.getName(), index);
                }
                int dir = DebugSourcesView.this.comparator.getDirection();
                DebugSourcesView.this.viewer.getTree().setSortDirection(dir);
                DebugSourcesView.this.viewer.getTree().setSortColumn(column);
                DebugSourcesView.this.viewer.refresh();
                DebugSourcesView.this.viewer.expandAll();
            }
        };
        return selectionAdapter;
    }

    private void createActions(TreeViewer viewer) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)new DebugSourcesExpandAction(viewer));
        toolBar.add((IAction)new DebugSourcesCollapseAction(viewer));
        toolBar.add((IAction)new DebugSourcesFlattendedTree(viewer));
        toolBar.add((IAction)new DebugSourcesNormalTree(viewer));
        toolBar.add((IAction)new DebugSourcesShowExistingFilesOnly(viewer));
    }

    private DsfSession getSession() {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return null;
        }
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null) {
            return null;
        }
        IDMContext dmcontext = (IDMContext)context.getAdapter(IDMContext.class);
        if (dmcontext == null) {
            return null;
        }
        String sessionId = dmcontext.getSessionId();
        DsfSession session = DsfSession.getSession((String)sessionId);
        if (session == null) {
            return null;
        }
        if (!session.isActive() || session.getExecutor().isShutdown()) {
            return null;
        }
        return session;
    }

    private void asyncExecRegisterForEvents() {
        if (this.getSite() == null || this.getSite().getShell() == null || this.getSite().getShell().getDisplay() == null || this.getSite().getShell().getDisplay().isDisposed()) {
            return;
        }
        this.getSite().getShell().getDisplay().asyncExec(this::registerForEvents);
    }

    private void registerForEvents() {
        DsfSession session = this.getSession();
        if (session == null) {
            return;
        }
        IAdaptable context = DebugUITools.getDebugContext();
        if (context == null) {
            return;
        }
        IDMContext dmcontext = (IDMContext)context.getAdapter(IDMContext.class);
        if (dmcontext == null) {
            return;
        }
        this.registerForEvents(session);
        this.displaySourceFiles(session, dmcontext);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        DsfSession lastSession;
        super.dispose();
        this.viewer.getControl().dispose();
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        if (this.fSession != null && !(lastSession = this.fSession).getExecutor().isShutdown()) {
            lastSession.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    lastSession.removeServiceEventListener((Object)DebugSourcesView.this);
                }
            });
        }
    }

    private void registerForEvents(DsfSession session) {
        if (session != null && this.fSession != session) {
            DsfSession lastSession;
            if (this.fSession != null && !(lastSession = this.fSession).getExecutor().isShutdown()) {
                lastSession.getExecutor().submit((Runnable)new DsfRunnable(){

                    public void run() {
                        lastSession.removeServiceEventListener((Object)DebugSourcesView.this);
                    }
                });
            }
            this.fSession = session;
            this.fSession.getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    DebugSourcesView.this.fSession.addServiceEventListener((Object)DebugSourcesView.this, null);
                }
            });
        }
    }

    private void displaySourceFiles(final DsfSession session, IDMContext dmcontext) {
        if (session.getExecutor().isShutdown()) {
            return;
        }
        final IRunControl.IContainerDMContext containerDMContext = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmcontext, IRunControl.IContainerDMContext.class);
        if (containerDMContext == null || Objects.equals(containerDMContext, this.dmcontext)) {
            return;
        }
        this.dmcontext = containerDMContext;
        session.getExecutor().submit((Runnable)new DsfRunnable(){

            public void run() {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
                IDebugSourceFiles srcService = (IDebugSourceFiles)tracker.getService(IDebugSourceFiles.class);
                tracker.dispose();
                if (srcService == null) {
                    return;
                }
                srcService.getSources((IDMContext)containerDMContext, (DataRequestMonitor)new DataRequestMonitor<IDebugSourceFiles.IDebugSourceFileInfo[]>((Executor)session.getExecutor(), null){

                    protected void handleSuccess() {
                        Job[] fileCheckJobS;
                        Job[] populateJobS;
                        IDebugSourceFiles.IDebugSourceFileInfo[] srcFileInfo = (IDebugSourceFiles.IDebugSourceFileInfo[])this.getData();
                        final PopulateTreeJob populateTreeJob = new PopulateTreeJob(srcFileInfo);
                        final CheckFileExistenceJob checkFileExistenceJob = new CheckFileExistenceJob();
                        populateTreeJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                DebugSourcesView.this.debugTree = populateTreeJob.getTree();
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!DebugSourcesView.this.viewer.getControl().isDisposed()) {
                                            DebugSourcesView.this.viewer.setInput((Object)DebugSourcesView.this.debugTree);
                                        }
                                    }
                                });
                                if (checkFileExistenceJob.getState() == 4) {
                                    checkFileExistenceJob.cancel();
                                }
                                checkFileExistenceJob.schedule();
                            }
                        });
                        checkFileExistenceJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!DebugSourcesView.this.viewer.getControl().isDisposed()) {
                                            DebugSourcesView.this.viewer.refresh();
                                        }
                                    }
                                });
                            }
                        });
                        IJobManager jobMan = Job.getJobManager();
                        Job[] jobArray = populateJobS = jobMan.find((Object)DebugSourcesView.POPULATE_FAMILY);
                        int n = populateJobS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Job job = jobArray[n2];
                            job.cancel();
                            ++n2;
                        }
                        Job[] jobArray2 = fileCheckJobS = jobMan.find((Object)DebugSourcesView.FILECHECK_FAMILY);
                        int n3 = fileCheckJobS.length;
                        n = 0;
                        while (n < n3) {
                            Job job = jobArray2[n];
                            job.cancel();
                            ++n;
                        }
                        populateTreeJob.schedule();
                    }

                    protected void handleError() {
                    }
                });
            }
        });
    }

    @DsfServiceEventHandler
    public void eventReceived(IRunControl.ISuspendedDMEvent event) {
        this.asyncExecRegisterForEvents();
    }

    @DsfServiceEventHandler
    public void eventReceived(IDebugSourceFiles.IDebugSourceFilesChangedEvent event) {
        this.asyncExecRegisterForEvents();
    }

    public boolean canRefresh() {
        return this.getSession() != null;
    }

    public void refresh() {
        this.dmcontext = null;
        final DsfSession session = this.getSession();
        if (session == null) {
            return;
        }
        session.getExecutor().submit((Runnable)new DsfRunnable(){

            public void run() {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
                IDebugSourceFiles srcService = (IDebugSourceFiles)tracker.getService(IDebugSourceFiles.class);
                tracker.dispose();
                if (srcService instanceof ICachingService) {
                    ICachingService cache = (ICachingService)srcService;
                    cache.flushCache((IDMContext)DebugSourcesView.this.dmcontext);
                }
            }
        });
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.registerForEvents();
        }
    }

    private void openSourceFile(String fullPath) {
        if (fullPath == null) {
            return;
        }
        Path path = Paths.get(fullPath, new String[0]);
        boolean exists = Files.exists(path, new LinkOption[0]);
        FileStoreEditorInput editorInput = null;
        String editorId = null;
        if (exists) {
            try {
                URI uriLocation = path.toUri();
                IFileStore fileStore = EFS.getStore((URI)uriLocation);
                editorInput = new FileStoreEditorInput(fileStore);
                editorId = IDE.getEditorDescriptorForFileStore((IFileStore)fileStore, (boolean)false).getId();
            }
            catch (CoreException e1) {
                CSourceNotFoundElement element = new CSourceNotFoundElement((IAdaptable)new TempElement(), null, fullPath);
                editorInput = new CSourceNotFoundEditorInput((Object)element);
                editorId = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
            }
        } else {
            CSourceNotFoundElement element = new CSourceNotFoundElement((IAdaptable)new TempElement(), null, fullPath);
            editorInput = new CSourceNotFoundEditorInput((Object)element);
            editorId = ICDebugUIConstants.CSOURCENOTFOUND_EDITOR_ID;
        }
        IWorkbenchPage page = CUIPlugin.getActivePage();
        try {
            page.openEditor((IEditorInput)editorInput, editorId);
        }
        catch (PartInitException e) {
            GdbUIPlugin.log(e);
        }
    }

    class CheckFileExistenceJob
    extends Job {
        public CheckFileExistenceJob() {
            super("Checking file existence");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                DebugSourcesTreeElement tmpTree = DebugSourcesView.this.debugTree;
                this.traverseDebugTree(tmpTree, monitor);
                DebugSourcesView.this.debugTree = tmpTree;
                if (monitor != null && monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Exception e) {
                GdbUIPlugin.log(e);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return DebugSourcesView.FILECHECK_FAMILY.equals(family);
        }

        private void traverseDebugTree(DebugSourcesTreeElement child, IProgressMonitor monitor) {
            Set<DebugSourcesTreeElement> children = child.getChildren();
            for (DebugSourcesTreeElement each : children) {
                String path = each.getFullPath();
                if (path != null) {
                    Path p = Paths.get(path, new String[0]);
                    boolean exists = Files.exists(p, new LinkOption[0]);
                    each.setExist(exists ? DebugSourcesTreeElement.FileExist.YES : DebugSourcesTreeElement.FileExist.NO);
                    if (!each.hasChildren() && exists) {
                        this.traverseParent(each);
                    }
                }
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                this.traverseDebugTree(each, monitor);
            }
            if (child.getExists() == DebugSourcesTreeElement.FileExist.UNKNOWN) {
                child.setExist(DebugSourcesTreeElement.FileExist.NO);
            }
        }

        private void traverseParent(DebugSourcesTreeElement node) {
            DebugSourcesTreeElement parent = node.getParent();
            if (parent.getExists() != DebugSourcesTreeElement.FileExist.YES) {
                parent.setExist(DebugSourcesTreeElement.FileExist.YES);
                if (parent.getParent() != null) {
                    this.traverseParent(parent);
                }
            }
        }
    }

    class DebugPatternFilter
    extends PatternFilter {
        DebugPatternFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            String name = ((DebugSourcesTreeElement)element).getName();
            String path = ((DebugSourcesTreeElement)element).getFullPath();
            return this.wordMatches(path) || this.wordMatches(name);
        }
    }

    class PopulateTreeJob
    extends Job {
        private IDebugSourceFiles.IDebugSourceFileInfo[] srcFileInfo;
        private DebugSourcesTreeElement populateTree;

        public PopulateTreeJob(IDebugSourceFiles.IDebugSourceFileInfo[] srcFileInfo) {
            super("Populate Tree Job");
            this.srcFileInfo = srcFileInfo;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.srcFileInfo == null) {
                return Status.CANCEL_STATUS;
            }
            this.populateTree = this.populateTree(this.srcFileInfo, monitor);
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return DebugSourcesView.POPULATE_FAMILY.equals(family);
        }

        public DebugSourcesTreeElement getTree() {
            return this.populateTree;
        }

        private DebugSourcesTreeElement populateTree(IDebugSourceFiles.IDebugSourceFileInfo[] srcFileInfo, IProgressMonitor monitor) {
            DebugSourcesTreeElement debugTree;
            DebugSourcesTreeElement current = debugTree = new DebugSourcesTreeElement("", DebugSourcesTreeElement.FileExist.UNKNOWN);
            int i = 0;
            while (i < srcFileInfo.length) {
                DebugSourcesTreeElement root;
                DebugSourcesTreeElement parent = root = current;
                String path = srcFileInfo[i].getPath();
                if (path != null) {
                    try {
                        Path p = Paths.get(path, new String[0]);
                        Path filename = p.getFileName();
                        Path pRoot = p.getRoot();
                        current = pRoot == null || !p.isAbsolute() ? current.addLeaf(DebugSourcesMessages.DebugSourcesView_unrooted, p.toString(), DebugSourcesTreeElement.FileExist.UNKNOWN) : (pRoot.equals(filename) ? current.addLeaf(srcFileInfo[i].getName(), p.toString(), DebugSourcesTreeElement.FileExist.UNKNOWN) : current.addNode(pRoot.toString(), DebugSourcesTreeElement.FileExist.UNKNOWN));
                        parent = current;
                        Path normalizedPath = p.normalize();
                        for (Path subpath : normalizedPath) {
                            current = subpath.equals(filename) ? current.addLeaf(srcFileInfo[i].getName(), p.toString(), DebugSourcesTreeElement.FileExist.UNKNOWN) : current.addNode(subpath.toString(), DebugSourcesTreeElement.FileExist.UNKNOWN);
                            current.setParent(parent);
                            parent = current;
                        }
                        current = root;
                        parent = root;
                    }
                    catch (InvalidPathException e) {
                        GdbUIPlugin.log(e);
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        return current;
                    }
                }
                ++i;
            }
            return current;
        }
    }

    private class TempElement
    implements IAdaptable,
    ICSourceNotFoundDescription {
        private TempElement() {
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == ICSourceNotFoundDescription.class) {
                return (T)this;
            }
            return null;
        }

        public String getDescription() {
            return DebugSourcesMessages.DebugSourcesMessages_unknown;
        }

        public boolean isAddressOnly() {
            return false;
        }
    }
}

