/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.internal.autotools.ui.SubstitutionTextReader;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;

public class HTML2TextReader
extends SubstitutionTextReader {
    private static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private static final Map<String, String> fgEntityLookup;
    private static final Set<String> fgTags;
    private int fCounter = 0;
    private TextPresentation fTextPresentation;
    private int fBold = 0;
    private int fStartOffset = -1;
    private boolean fInParagraph = false;

    static {
        fgTags = new HashSet<String>();
        fgTags.add("b");
        fgTags.add("br");
        fgTags.add("h5");
        fgTags.add("p");
        fgTags.add("dl");
        fgTags.add("dt");
        fgTags.add("dd");
        fgTags.add("li");
        fgTags.add("ul");
        fgEntityLookup = new HashMap<String, String>(7);
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
    }

    public HTML2TextReader(Reader reader, TextPresentation presentation) {
        super(new PushbackReader(reader));
        this.fTextPresentation = presentation;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this.fCounter;
        }
        return c;
    }

    protected void startBold() {
        if (this.fBold == 0) {
            this.fStartOffset = this.fCounter;
        }
        ++this.fBold;
    }

    protected void stopBold() {
        --this.fBold;
        if (this.fBold == 0) {
            if (this.fTextPresentation != null) {
                this.fTextPresentation.addStyleRange(new StyleRange(this.fStartOffset, this.fCounter - this.fStartOffset, null, null, 1));
            }
            this.fStartOffset = -1;
        }
    }

    @Override
    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processHTMLTag();
        }
        if (c == 38) {
            return this.processEntity();
        }
        return null;
    }

    private String html2Text(String html) {
        String tag = html;
        if ('/' == tag.charAt(0)) {
            tag = tag.substring(1);
        }
        if (!fgTags.contains(tag)) {
            return "";
        }
        if ("b".equals(html)) {
            this.startBold();
            return "";
        }
        if ("h5".equals(html) || "dt".equals(html)) {
            this.startBold();
            return "";
        }
        if ("dl".equals(html)) {
            return LINE_DELIM;
        }
        if ("dd".equals(html)) {
            return "\t";
        }
        if ("li".equals(html)) {
            return String.valueOf(LINE_DELIM) + "\t" + "-";
        }
        if ("/b".equals(html)) {
            this.stopBold();
            return "";
        }
        if ("p".equals(html)) {
            this.fInParagraph = true;
            return LINE_DELIM;
        }
        if ("br".equals(html)) {
            return LINE_DELIM;
        }
        if ("/p".equals(html)) {
            boolean inParagraph = this.fInParagraph;
            this.fInParagraph = false;
            return inParagraph ? "" : LINE_DELIM;
        }
        if ("/h5".equals(html) || "/dt".equals(html)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/dd".equals(html)) {
            return LINE_DELIM;
        }
        return "";
    }

    private String processHTMLTag() throws IOException {
        StringBuilder buf = new StringBuilder();
        while (true) {
            int ch = this.nextChar();
            while (ch != -1 && ch != 62) {
                buf.append(Character.toLowerCase((char)ch));
                ch = this.nextChar();
                if (ch == 34) {
                    buf.append(Character.toLowerCase((char)ch));
                    ch = this.nextChar();
                    while (ch != -1 && ch != 34) {
                        buf.append(Character.toLowerCase((char)ch));
                        ch = this.nextChar();
                    }
                }
                if (ch != 60) continue;
                this.unread(ch);
                return String.valueOf('<') + buf.toString();
            }
            if (ch == -1) {
                return null;
            }
            int tagLen = buf.length();
            if (tagLen < 3 || !"!--".equals(buf.substring(0, 3)) || tagLen >= 5 && "--!".equals(buf.substring(tagLen - 3))) break;
            buf.append(ch);
        }
        return this.html2Text(buf.toString());
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
    }

    protected String entity2Text(String symbol) {
        if (symbol.length() > 1 && symbol.charAt(0) == '#') {
            try {
                int ch = symbol.charAt(1) == 'x' ? Integer.parseInt(symbol.substring(2), 16) : Integer.parseInt(symbol.substring(1), 10);
                return "" + (char)ch;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String str = fgEntityLookup.get(symbol);
            if (str != null) {
                return str;
            }
        }
        return "&" + symbol;
    }

    private String processEntity() throws IOException {
        StringBuilder buf = new StringBuilder();
        int ch = this.nextChar();
        while (Character.isLetterOrDigit((char)ch) || ch == 35) {
            buf.append((char)ch);
            ch = this.nextChar();
        }
        if (ch == 59) {
            return this.entity2Text(buf.toString());
        }
        buf.insert(0, '&');
        if (ch != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

