/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.remote;

import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.arduino.ui.internal.remote.BoardPropertyControl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewArduinoTargetWizardPage
extends WizardPage {
    private String connectionName;
    private Text nameText;
    private IRemoteConnectionWorkingCopy workingCopy;
    BoardPropertyControl boardControl;

    public NewArduinoTargetWizardPage() {
        super("NewArduinoTargetPage");
        this.setDescription(Messages.NewArduinoTargetWizardPage_0);
        this.setTitle(Messages.NewArduinoTargetWizardPage_1);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        Composite nameComp = new Composite(comp, 0);
        nameComp.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(nameComp, 0);
        nameLabel.setText(Messages.NewArduinoTargetWizardPage_2);
        this.nameText = new Text(nameComp, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(Messages.NewArduinoTargetWizardPage_3);
        this.nameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                NewArduinoTargetWizardPage.this.connectionName = NewArduinoTargetWizardPage.this.nameText.getText();
                NewArduinoTargetWizardPage.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.boardControl = new BoardPropertyControl(comp, 0);
        this.boardControl.setLayoutData(new GridData(4, 4, true, false));
        this.boardControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewArduinoTargetWizardPage.this.updateStatus();
            }
        });
        try {
            this.updateFromWorkingCopy();
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        this.setControl((Control)comp);
        this.updateStatus();
    }

    private void updateStatus() {
        this.setPageComplete(this.connectionName != null && !this.connectionName.isEmpty() && this.boardControl.getPortName() != null && this.boardControl.getSelectedBoard() != null);
    }

    public void performFinish(IRemoteConnectionWorkingCopy workingCopy) {
        this.boardControl.apply(workingCopy);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setWorkingCopy(IRemoteConnectionWorkingCopy workingCopy) {
        this.workingCopy = workingCopy;
    }

    private void updateFromWorkingCopy() throws CoreException {
        if (this.workingCopy == null || this.workingCopy.getOriginal() == null) {
            return;
        }
        ArduinoRemoteConnection arduinoService = (ArduinoRemoteConnection)this.workingCopy.getService(ArduinoRemoteConnection.class);
        if (arduinoService == null) {
            return;
        }
        this.nameText.setText(this.workingCopy.getOriginal().getName());
        this.nameText.setEnabled(false);
        this.connectionName = this.workingCopy.getOriginal().getName();
        this.boardControl.updateFromOriginal(arduinoService);
    }
}

