/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.RevalidateLinksCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.DragEditPartsTracker;

public class BPELDragEditPartsTracker
extends DragEditPartsTracker {
    public BPELDragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
    }

    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand(Messages.BPELDragEditPartsTracker_Drag_1);
        command.setDebugLabel("Drag Object Tracker");
        Iterator iter = this.getOperationSet().iterator();
        HashSet<Object> activitiesNeedingRevalidation = null;
        while (iter.hasNext()) {
            Object model;
            EditPart editPart = (EditPart)iter.next();
            Request request = this.getTargetRequest();
            ((ChangeBoundsRequest)request).setEditParts(editPart);
            boolean isMove = editPart.getParent() == this.getTargetEditPart();
            request.setType((Object)(isMove ? "move" : "orphan"));
            command.add(editPart.getCommand(request));
            if (!isMove) {
                request.setType((Object)"add children");
                if (this.getTargetEditPart() == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
            }
            if (isMove || !((model = editPart.getModel()) instanceof Activity)) continue;
            if (activitiesNeedingRevalidation == null) {
                activitiesNeedingRevalidation = new HashSet<Object>();
            }
            activitiesNeedingRevalidation.add(model);
        }
        if (activitiesNeedingRevalidation != null) {
            command.add((Command)new RevalidateLinksCommand(activitiesNeedingRevalidation));
        }
        return command;
    }
}

