/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.details.providers.VariableTreeContentProvider;
import org.eclipse.bpel.ui.details.tree.BPELVariableTreeNode;
import org.eclipse.bpel.ui.details.tree.ITreeNode;
import org.eclipse.bpel.ui.details.tree.PartTreeNode;
import org.eclipse.bpel.ui.details.tree.TreeNode;
import org.eclipse.bpel.ui.details.tree.XSDAttributeDeclarationTreeNode;
import org.eclipse.bpel.ui.details.tree.XSDElementDeclarationTreeNode;
import org.eclipse.bpel.ui.expressions.XPathExpressionUtil;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;

public class ElementTreePreviewSelectionDialog
extends ElementTreeSelectionDialog {
    protected Label previewLabel;
    protected Text previewText;
    protected Label filterLabel;
    protected Text filterText;
    private String thePreviewText;
    private String theFilter = "";

    public ElementTreePreviewSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.addFilter(new TreeFilter());
    }

    protected void updatePreviewText(IStructuredSelection selection) {
        if (this.previewText == null) {
            return;
        }
        VariableTreeContentProvider contentProvider = (VariableTreeContentProvider)super.getTreeViewer().getContentProvider();
        Object[] path = contentProvider.getPathToRoot(selection.getFirstElement());
        String preview = "$";
        if (path != null) {
            Variable var = null;
            int i = path.length - 1;
            while (i >= 0) {
                String targetNamespace = null;
                String namespacePrefix = null;
                String segment = null;
                Object modelObject = BPELUtil.resolveXSDObject(((ITreeNode)path[i]).getModelObject());
                if (modelObject instanceof Variable) {
                    var = (Variable)modelObject;
                    segment = var.getName();
                } else if (modelObject instanceof XSDAttributeDeclaration) {
                    XSDAttributeDeclaration att = (XSDAttributeDeclaration)modelObject;
                    targetNamespace = att.getTargetNamespace();
                    if (targetNamespace != null) {
                        namespacePrefix = BPELUtils.getNamespacePrefix((EObject)var, (String)targetNamespace);
                        Assert.isNotNull((Object)namespacePrefix, (String)XPathExpressionUtil.MSG_NS_PREFIX_NULL);
                        segment = "/@" + namespacePrefix + ":" + att.getName();
                    } else {
                        segment = "/@" + att.getName();
                    }
                } else if (modelObject instanceof XSDElementDeclaration) {
                    boolean isArray;
                    XSDElementDeclaration elm = (XSDElementDeclaration)modelObject;
                    targetNamespace = elm.getTargetNamespace();
                    XSDTypeDefinition typeDef = elm.getType();
                    XSDParticle particle = typeDef.getComplexType();
                    boolean bl = isArray = particle != null && (particle.getMaxOccurs() == -1 || particle.getMaxOccurs() > 1);
                    if (targetNamespace != null) {
                        namespacePrefix = BPELUtils.getNamespacePrefix((EObject)var, (String)targetNamespace);
                        Assert.isNotNull((Object)namespacePrefix, (String)XPathExpressionUtil.MSG_NS_PREFIX_NULL);
                        segment = "/" + namespacePrefix + ":" + elm.getName();
                    } else {
                        segment = "/" + elm.getName();
                    }
                    if (isArray) {
                        segment = String.valueOf(segment) + "[1]";
                    }
                } else if (modelObject instanceof Part) {
                    Part part = (Part)modelObject;
                    segment = "." + part.getName();
                }
                if (segment != null) {
                    preview = String.valueOf(preview) + segment;
                }
                --i;
            }
            this.previewText.setText(preview);
            this.thePreviewText = preview;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite filter = new Composite(parent, 0);
        GridData data1 = new GridData(1808);
        filter.setLayoutData((Object)data1);
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 1;
        layout1.makeColumnsEqualWidth = false;
        filter.setLayout((Layout)layout1);
        this.filterLabel = new Label(filter, 0);
        this.filterLabel.setText(XPathExpressionUtil.LBL_FILTER_TEXT);
        data1 = new GridData();
        data1.widthHint = 80;
        this.filterLabel.setLayoutData((Object)data1);
        this.filterText = new Text(filter, 2048);
        data1 = new GridData(768);
        this.filterText.setLayoutData((Object)data1);
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ElementTreePreviewSelectionDialog.this.theFilter = ElementTreePreviewSelectionDialog.this.filterText.getText();
                if (ElementTreePreviewSelectionDialog.this.theFilter.length() > 0) {
                    ElementTreePreviewSelectionDialog.this.getTreeViewer().refresh();
                    ElementTreePreviewSelectionDialog.this.getTreeViewer().expandAll();
                } else {
                    ElementTreePreviewSelectionDialog.this.getTreeViewer().refresh();
                    ElementTreePreviewSelectionDialog.this.getTreeViewer().collapseAll();
                }
            }
        });
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite previewMain = new Composite(parent, 0);
        GridData data = new GridData(1808);
        previewMain.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        previewMain.setLayout((Layout)layout);
        this.previewLabel = new Label(previewMain, 0);
        this.previewLabel.setText(XPathExpressionUtil.LBL_PREVIEW_TEXT);
        data = new GridData();
        data.widthHint = 80;
        this.previewLabel.setLayoutData((Object)data);
        this.previewText = new Text(previewMain, 2048);
        data = new GridData(768);
        this.previewText.setLayoutData((Object)data);
        TreeViewer treeViewer = super.getTreeViewer();
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementTreePreviewSelectionDialog.this.updatePreviewText((IStructuredSelection)event.getSelection());
            }
        });
        return comp;
    }

    public String getPreviewResult() {
        return this.thePreviewText;
    }

    public class TreeFilter
    extends ViewerFilter {
        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            int size = elements.length;
            ArrayList<Object> out = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                Object element = elements[i];
                if (this.select(viewer, parent, element)) {
                    out.add(element);
                }
                ++i;
            }
            return out.toArray();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Part part;
            XSDAttributeDeclaration xsdattribute;
            XSDElementDeclaration xsdelem;
            Variable var;
            if (element instanceof BPELVariableTreeNode ? (var = (Variable)((BPELVariableTreeNode)element).getModelObject()).getName().indexOf(ElementTreePreviewSelectionDialog.this.theFilter) > -1 : (element instanceof XSDElementDeclarationTreeNode ? (xsdelem = ((XSDElementDeclarationTreeNode)element).getResolvedModelObject()).getName().indexOf(ElementTreePreviewSelectionDialog.this.theFilter) > -1 : (element instanceof XSDAttributeDeclarationTreeNode ? (xsdattribute = ((XSDAttributeDeclarationTreeNode)element).getResolvedModelObject()).getName().indexOf(ElementTreePreviewSelectionDialog.this.theFilter) > -1 : element instanceof PartTreeNode && (part = (Part)((PartTreeNode)element).getModelObject()).getName().indexOf(ElementTreePreviewSelectionDialog.this.theFilter) > -1))) {
                return true;
            }
            if (((TreeNode)element).hasChildren()) {
                Object[] children = ((TreeNode)element).getChildren();
                int i = 0;
                while (i < children.length) {
                    if (this.select(viewer, element, children[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

