/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.TrackingTmpOutputDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

final class SortingTermVectorsConsumer
extends TermVectorsConsumer {
    TrackingTmpOutputDirectoryWrapper tmpDirectory;

    public SortingTermVectorsConsumer(DocumentsWriterPerThread docWriter) {
        super(docWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        super.flush(fieldsToFlush, state, sortMap);
        if (this.tmpDirectory != null) {
            if (sortMap == null) {
                for (Map.Entry<String, String> entry : this.tmpDirectory.getTemporaryFiles().entrySet()) {
                    this.tmpDirectory.rename(entry.getValue(), entry.getKey());
                }
                return;
            }
            TermVectorsReader reader = this.docWriter.codec.termVectorsFormat().vectorsReader(this.tmpDirectory, state.segmentInfo, state.fieldInfos, IOContext.DEFAULT);
            TermVectorsReader mergeReader = reader.getMergeInstance();
            TermVectorsWriter writer = this.docWriter.codec.termVectorsFormat().vectorsWriter(state.directory, state.segmentInfo, IOContext.DEFAULT);
            try {
                reader.checkIntegrity();
                for (int docID = 0; docID < state.segmentInfo.maxDoc(); ++docID) {
                    Fields vectors = mergeReader.get(sortMap.newToOld(docID));
                    SortingTermVectorsConsumer.writeTermVectors(writer, vectors, state.fieldInfos);
                }
                writer.finish(state.fieldInfos, state.segmentInfo.maxDoc());
            }
            catch (Throwable throwable) {
                IOUtils.close(reader, writer);
                IOUtils.deleteFiles((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
                throw throwable;
            }
            IOUtils.close(reader, writer);
            IOUtils.deleteFiles((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
        }
    }

    @Override
    void initTermVectorsWriter() throws IOException {
        if (this.writer == null) {
            IOContext context = new IOContext(new FlushInfo(this.docWriter.getNumDocsInRAM(), this.docWriter.bytesUsed()));
            this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.docWriter.directory);
            this.writer = this.docWriter.codec.termVectorsFormat().vectorsWriter(this.tmpDirectory, this.docWriter.getSegmentInfo(), context);
            this.lastDocID = 0;
        }
    }

    @Override
    public void abort() {
        try {
            super.abort();
        }
        finally {
            IOUtils.deleteFilesIgnoringExceptions((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
        }
    }

    private static void writeTermVectors(TermVectorsWriter writer, Fields vectors, FieldInfos fieldInfos) throws IOException {
        if (vectors == null) {
            writer.startDocument(0);
            writer.finishDocument();
            return;
        }
        int numFields = vectors.size();
        if (numFields == -1) {
            numFields = 0;
            Iterator<String> it = vectors.iterator();
            while (it.hasNext()) {
                it.next();
                ++numFields;
            }
        }
        writer.startDocument(numFields);
        String lastFieldName = null;
        TermsEnum termsEnum = null;
        PostingsEnum docsAndPositionsEnum = null;
        int fieldCount = 0;
        for (String fieldName : vectors) {
            ++fieldCount;
            FieldInfo fieldInfo = fieldInfos.fieldInfo(fieldName);
            assert (lastFieldName == null || fieldName.compareTo(lastFieldName) > 0) : "lastFieldName=" + lastFieldName + " fieldName=" + fieldName;
            lastFieldName = fieldName;
            Terms terms = vectors.terms(fieldName);
            if (terms == null) continue;
            boolean hasPositions = terms.hasPositions();
            boolean hasOffsets = terms.hasOffsets();
            boolean hasPayloads = terms.hasPayloads();
            assert (!hasPayloads || hasPositions);
            int numTerms = (int)terms.size();
            if (numTerms == -1) {
                numTerms = 0;
                termsEnum = terms.iterator();
                while (termsEnum.next() != null) {
                    ++numTerms;
                }
            }
            writer.startField(fieldInfo, numTerms, hasPositions, hasOffsets, hasPayloads);
            termsEnum = terms.iterator();
            int termCount = 0;
            while (termsEnum.next() != null) {
                ++termCount;
                int freq = (int)termsEnum.totalTermFreq();
                writer.startTerm(termsEnum.term(), freq);
                if (hasPositions || hasOffsets) {
                    docsAndPositionsEnum = termsEnum.postings(docsAndPositionsEnum, 120);
                    assert (docsAndPositionsEnum != null);
                    int docID = docsAndPositionsEnum.nextDoc();
                    assert (docID != Integer.MAX_VALUE);
                    assert (docsAndPositionsEnum.freq() == freq);
                    for (int posUpto = 0; posUpto < freq; ++posUpto) {
                        int pos = docsAndPositionsEnum.nextPosition();
                        int startOffset = docsAndPositionsEnum.startOffset();
                        int endOffset = docsAndPositionsEnum.endOffset();
                        BytesRef payload = docsAndPositionsEnum.getPayload();
                        assert (!hasPositions || pos >= 0);
                        writer.addPosition(pos, startOffset, endOffset, payload);
                    }
                }
                writer.finishTerm();
            }
            assert (termCount == numTerms);
            writer.finishField();
        }
        assert (fieldCount == numFields);
        writer.finishDocument();
    }
}

