/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.processor;

import java.util.Collections;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8ContextFilter;
import org.eclipse.wst.jsdt.chromium.internal.v8native.processor.V8EventProcessor;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.V8ProtocolUtil;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.AfterCompileBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.EventNotification;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ScriptHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;

public class AfterCompileProcessor
extends V8EventProcessor {
    public AfterCompileProcessor(DebugSession debugSession) {
        super(debugSession);
    }

    @Override
    public void messageReceived(EventNotification eventMessage) {
        final DebugSession debugSession = this.getDebugSession();
        ScriptHandle script = AfterCompileProcessor.getScriptToLoad(eventMessage, debugSession.getScriptManager().getContextFilter());
        if (script == null) {
            return;
        }
        debugSession.sendMessageAsync(DebuggerMessageFactory.scripts(Collections.singletonList(V8ProtocolUtil.getScriptIdFromResponse(script)), (Boolean)true), true, new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                List<ScriptHandle> body;
                try {
                    body = successResponse.body().asScripts();
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException(e);
                }
                if (body.size() == 0) {
                    return;
                }
                debugSession.getScriptManager().addScript(body.get(0), successResponse.refs());
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
            }
        }, null);
    }

    private static ScriptHandle getScriptToLoad(EventNotification eventResponse, V8ContextFilter contextFilter) {
        AfterCompileBody body;
        try {
            body = eventResponse.body().asAfterCompileBody();
        }
        catch (JsonProtocolParseException e) {
            throw new RuntimeException(e);
        }
        ScriptHandle script = body.script();
        if ("javascript:void(0);".equals(script.sourceStart()) || script.context() == null || V8ProtocolUtil.getScriptType(script.scriptType()) == Script.Type.NATIVE) {
            return null;
        }
        return V8ProtocolUtil.validScript(script, eventResponse.refs(), contextFilter);
    }
}

