/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.model.association;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssociationUtils {
    private AssociationUtils() {
    }

    public static void updateParentAssociation(AbstractInvocationDescription description, List<Expression> arguments, JavaInfo newParent) throws Exception {
        for (ParameterDescription parameter : description.getParameters()) {
            if (!parameter.isParent()) continue;
            Expression argument = arguments.get(parameter.getIndex());
            String replacement = TemplateUtils.getExpression(newParent);
            newParent.replaceExpression(argument, replacement);
        }
    }

    public static String replaceTemplates(JavaInfo child, String source, StatementTarget target) throws Exception {
        return AssociationUtils.replaceTemplates(child, source, new NodeTarget(target));
    }

    public static String replaceTemplates(JavaInfo child, String source, NodeTarget target) throws Exception {
        Map<String, String> templateArguments;
        ObjectInfo parentInfo;
        String[] sourceArray = new String[]{source};
        child.getBroadcastJava().associationTemplate(child, sourceArray);
        source = sourceArray[0];
        if (source.contains("%parent%")) {
            source = StringUtils.replace((String)source, (String)"%parent%", (String)TemplateUtils.getExpression(child.getParentJava()));
        }
        if (source.contains("%child%")) {
            source = StringUtils.replace((String)source, (String)"%child%", (String)TemplateUtils.getExpression(child));
        }
        if (source.contains("%index%") && (parentInfo = child.getParent()) != null) {
            int index = parentInfo.getChildren(JavaInfo.class).size();
            source = StringUtils.replace((String)source, (String)"%index%", (String)Integer.toString(index));
        }
        if ((templateArguments = child.getTemplateArguments()) != null) {
            for (Map.Entry<String, String> template : templateArguments.entrySet()) {
                source = StringUtils.replace((String)source, (String)("%" + template.getKey() + "%"), (String)template.getValue());
            }
        }
        source = TemplateUtils.resolve(target, source);
        return source;
    }
}

