/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal;

import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.sdk.core.log.ISdkConsoleSpi;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.S2ESdkActivator;
import org.eclipse.scout.sdk.s2e.ui.internal.S2ESdkUiActivator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class WorkbenchSdkConsoleSpi
implements ISdkConsoleSpi {
    public static final String CONSOLE_NAME = "Scout SDK";
    public static final String CONSOLE_TYPE = "org.eclipse.scout.sdk";

    public void clear() {
        IOConsole console = WorkbenchSdkConsoleSpi.currentConsole(false);
        if (console != null) {
            console.clearConsole();
        }
    }

    public void println(Level level, String s, Throwable ... exceptions) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (IOConsoleOutputStream out = WorkbenchSdkConsoleSpi.currentConsole(true).newOutputStream();){
                if (Level.SEVERE.equals(level)) {
                    IWorkbench workbench;
                    out.setActivateOnWrite(true);
                    if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null) {
                        Display display = workbench.getDisplay();
                        display.syncExec(() -> out.setColor(display.getSystemColor(3)));
                    }
                }
                out.write(s);
                if (exceptions == null || exceptions.length < 1) {
                    out.write(10);
                } else {
                    Throwable[] throwableArray = exceptions;
                    int n = exceptions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Throwable t = throwableArray[n2];
                        if (t != null) {
                            String trace = Strings.fromThrowable((Throwable)t);
                            out.write(trace);
                        }
                        ++n2;
                    }
                }
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("Unable to write to console:");
            System.err.println(s);
            e.printStackTrace();
        }
        if (Platform.isRunning() && (Platform.inDebugMode() || Platform.inDevelopmentMode())) {
            S2ESdkActivator activator = S2ESdkActivator.getDefault();
            if (activator == null) {
                return;
            }
            Throwable t = null;
            if (exceptions != null && exceptions.length > 0) {
                t = exceptions[0];
            }
            activator.getLog().log((IStatus)new Status(WorkbenchSdkConsoleSpi.julToEclipseSeverity(level), "org.eclipse.scout.sdk.s2e", s, t));
        }
    }

    private static int julToEclipseSeverity(Level l) {
        if (l.intValue() == Level.SEVERE.intValue()) {
            return 4;
        }
        if (l.intValue() == Level.WARNING.intValue()) {
            return 2;
        }
        return 1;
    }

    public static IOConsole currentConsole(boolean autoCreate) {
        IConsoleManager mgr = ConsolePlugin.getDefault().getConsoleManager();
        IOConsole console = null;
        IConsole[] iConsoleArray = mgr.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole c = iConsoleArray[n2];
            if (CONSOLE_NAME.equals(c.getName()) && CONSOLE_TYPE.equals(c.getType())) {
                if (console == null) {
                    console = (IOConsole)c;
                } else {
                    mgr.removeConsoles(new IConsole[]{c});
                }
            }
            ++n2;
        }
        if (console == null && autoCreate) {
            console = new IOConsole(CONSOLE_NAME, CONSOLE_TYPE, S2ESdkUiActivator.getImageDescriptor("eclipse_scout.gif")){

                public void clearConsole() {
                    super.clearConsole();
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
                }
            };
            mgr.addConsoles(new IConsole[]{console});
            mgr.showConsoleView((IConsole)console);
        }
        return console;
    }
}

