/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.lookup;

import java.util.ArrayList;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.condition.ActiveShellExists;
import org.eclipse.reddeer.core.condition.ShellMatchingMatcherIsAvailable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.util.DiagnosticTool;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public class ShellLookup {
    private static ShellLookup instance = null;

    private ShellLookup() {
    }

    public static ShellLookup getInstance() {
        if (instance == null) {
            instance = new ShellLookup();
        }
        return instance;
    }

    public Shell getActiveShell() {
        new WaitUntil((WaitCondition)new ActiveShellExists(), TimePeriod.SHORT, false);
        Shell activeShell = this.getCurrentActiveShell();
        if (activeShell == null) {
            new WaitUntil((WaitCondition)new ShellIsFocused(), TimePeriod.SHORT, false);
            activeShell = this.getCurrentFocusShell();
        }
        if (activeShell == null) {
            activeShell = this.getLastVisibleShell();
        }
        return activeShell;
    }

    public Shell getCurrentActiveShell() {
        return (Shell)Display.syncExec((ResultRunnable)new ResultRunnable<Shell>(){

            public Shell run() {
                Shell s = Display.getDisplay().getActiveShell();
                if (s != null && s.isVisible()) {
                    return s;
                }
                return null;
            }
        });
    }

    public Shell getCurrentFocusShell() {
        return (Shell)Display.syncExec((ResultRunnable)new ResultRunnable<Shell>(){

            public Shell run() {
                Shell[] ss;
                Shell[] shellArray = ss = Display.getDisplay().getShells();
                int n = ss.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (shell.isFocusControl() && shell.isVisible()) {
                        return shell;
                    }
                    ++n2;
                }
                return null;
            }
        });
    }

    public Shell[] getShells() {
        return (Shell[])Display.syncExec((ResultRunnable)new ResultRunnable<Shell[]>(){

            public Shell[] run() {
                Shell[] shells;
                ArrayList<Shell> visibleShells = new ArrayList<Shell>();
                Shell[] shellArray = shells = Display.getDisplay().getShells();
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell s = shellArray[n2];
                    if (!s.isDisposed() && s.isVisible()) {
                        visibleShells.add(s);
                    }
                    ++n2;
                }
                return visibleShells.toArray(new Shell[visibleShells.size()]);
            }
        });
    }

    public Shell getShell(TimePeriod timePeriod, Matcher<?> ... matchers) {
        ShellMatchingMatcherIsAvailable shellCondition = new ShellMatchingMatcherIsAvailable(matchers);
        try {
            new WaitUntil((WaitCondition)shellCondition, timePeriod);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            String exceptionText = shellCondition.errorMessageUntil();
            exceptionText = String.valueOf(exceptionText) + "\n" + new DiagnosticTool().getShellsDiagnosticInformation();
            throw new CoreLayerException(exceptionText);
        }
        return shellCondition.getResult();
    }

    public Shell getShell(Matcher<?> ... matchers) {
        return this.getShell(TimePeriod.DEFAULT, matchers);
    }

    public Shell getShell(String title, TimePeriod timePeriod) {
        return this.getShell(timePeriod, new Matcher[]{new WithTextMatcher(title)});
    }

    public Shell getShell(String title) {
        return this.getShell(TimePeriod.DEFAULT, new Matcher[]{new WithTextMatcher(title)});
    }

    private Shell getLastVisibleShell() {
        return (Shell)Display.syncExec((ResultRunnable)new ResultRunnable<Shell>(){

            public Shell run() {
                Shell[] shells = Display.getDisplay().getShells();
                int i = shells.length - 1;
                while (i >= 0) {
                    if (shells[i].isVisible()) {
                        return shells[i];
                    }
                    --i;
                }
                return null;
            }
        });
    }

    public Shell getParentShell(Shell shell) {
        Composite parent = ControlHandler.getInstance().getParent((Control)shell);
        return parent == null ? null : (Shell)parent;
    }

    public Shell[] getShells(final Shell shell) {
        return (Shell[])Display.syncExec((ResultRunnable)new ResultRunnable<Shell[]>(){

            public Shell[] run() {
                return shell.getShells();
            }
        });
    }

    class ShellIsFocused
    extends AbstractWaitCondition {
        ShellIsFocused() {
        }

        public boolean test() {
            return ShellLookup.this.getCurrentFocusShell() != null;
        }

        public String description() {
            return "shell is focused";
        }
    }
}

