/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.views;

import java.util.BitSet;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ptp.internal.ui.PTPUIPlugin;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.AbstractParallelElementView;
import org.eclipse.ptp.internal.ui.views.IconCanvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ElementIconCanvas
extends IconCanvas
implements ISelectionProvider {
    private IElementSet cur_element_set = null;
    private final ListenerList listeners = new ListenerList();
    private ISelection selection = null;

    public ElementIconCanvas(AbstractParallelElementView view, Composite parent, int style) {
        super(parent, style);
        IPreferenceStore store = PTPUIPlugin.getDefault().getPreferenceStore();
        this.setIconSpace(store.getInt("icon_spacing_x"), store.getInt("icon_spacing_y"));
        this.setIconSize(store.getInt("icon_width"), store.getInt("icon_height"));
        this.setTooltip(store.getBoolean("tt_show_all_time"), store.getLong("tt_timeout"), store.getBoolean("tt_iswap"));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void dispose() {
        this.listeners.clear();
        this.selection = null;
        this.cur_element_set = null;
        super.dispose();
    }

    @Override
    protected void doSelectionAll() {
        super.doSelectionAll();
        this.setSelection((ISelection)new StructuredSelection((Object)this.getSelectedElements()));
    }

    public IElementSet getCurrentElementSet() {
        return this.cur_element_set;
    }

    @Override
    public BitSet getSelectedElements() {
        if (this.cur_element_set == null) {
            return new BitSet();
        }
        return this.selectedElements;
    }

    public ISelection getSelection() {
        if (this.selection == null) {
            return StructuredSelection.EMPTY;
        }
        return this.selection;
    }

    @Override
    protected void handleMouseUp(Event event) {
        super.handleMouseUp(event);
        this.setSelection((ISelection)new StructuredSelection((Object)this.getSelectedElements()));
    }

    public boolean hasElement(int index) {
        if (this.cur_element_set == null) {
            return false;
        }
        boolean element = this.cur_element_set.contains(index);
        if (element) {
            this.cur_element_set.setSelected(index, this.selectedElements.get(index));
        }
        return element;
    }

    public int getElement(int index) {
        if (this.cur_element_set == null) {
            return -1;
        }
        return this.cur_element_set.getElement(index);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setCurrentSelection(boolean sendEvent) {
        this.setCurrentSelection(sendEvent, this.getSelectedElements());
    }

    protected void setCurrentSelection(boolean sendEvent, BitSet elements) {
        this.selection = new StructuredSelection((Object)elements);
        if (sendEvent) {
            this.setSelection(this.selection);
        }
    }

    public void setElementSet(IElementSet e_set) {
        this.cur_element_set = e_set;
        this.selection = null;
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ElementIconCanvas.this.setTotal(ElementIconCanvas.this.cur_element_set == null ? 0 : ElementIconCanvas.this.cur_element_set.size());
            }
        });
    }

    public void setSelection(ISelection selection) {
        Object[] array;
        this.selection = selection;
        final SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] objectArray = array = this.listeners.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)element;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(e);
                }
            });
            ++n2;
        }
    }

    public void updateToolTipText(final String content) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ElementIconCanvas.this.fInformationControl != null) {
                    ElementIconCanvas.this.fInformationControl.setInformation(content);
                    ElementIconCanvas.this.fInformationControl.getShellSize();
                }
            }
        });
    }
}

