/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openacc.internal.editorHelp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import org.eclipse.ptp.pldt.common.editorHelp.CHelpBookImpl;
import org.eclipse.ptp.pldt.openacc.internal.Activator;
import org.eclipse.ptp.pldt.openacc.internal.messages.Messages;

public class OpenACCCHelpBook
extends CHelpBookImpl {
    private static final String TITLE = Messages.OpenACCCHelpBook_Title;

    OpenACCCHelpBook() {
        super(Activator.getPluginId());
        this.func("acc_get_num_devices", Messages.OpenACCCHelpBook_Description_acc_get_num_devices, "int", "acc_device_t");
        this.func("acc_set_device_type", Messages.OpenACCCHelpBook_Description_acc_set_device_type, "void", "acc_device_t");
        this.func("acc_get_device_type", Messages.OpenACCCHelpBook_Description_acc_get_device_type, "acc_device_t", "");
        this.func("acc_set_device_num", Messages.OpenACCCHelpBook_Description_acc_set_device_num, "void", "int, acc_device_t");
        this.func("acc_get_device_num", Messages.OpenACCCHelpBook_Description_acc_get_device_num, "int", "acc_device_t");
        this.func("acc_async_test", Messages.OpenACCCHelpBook_Description_acc_async_test, "int", "int");
        this.func("acc_async_test_all", Messages.OpenACCCHelpBook_Description_acc_async_test_all, "int", "");
        this.func("acc_async_wait", Messages.OpenACCCHelpBook_Description_acc_async_wait, "void", "int");
        this.func("acc_async_wait_all", Messages.OpenACCCHelpBook_Description_acc_async_wait_all, "void", "");
        this.func("acc_init", Messages.OpenACCCHelpBook_Description_acc_init, "void", "acc_device_type");
        this.func("acc_shutdown", Messages.OpenACCCHelpBook_Description_acc_shutdown, "void", "acc_device_t");
        this.func("acc_on_device", Messages.OpenACCCHelpBook_Description_acc_on_device, "int", "acc_device_t");
        this.func("acc_malloc", Messages.OpenACCCHelpBook_Description_acc_malloc, "void*", "size_t");
        this.func("acc_free", Messages.OpenACCCHelpBook_Description_acc_free, "void", "void*");
        this.setTitle(TITLE);
    }

    public static void main(String[] args) throws IOException {
        System.out.print("Enter directory to write HTML files to: ");
        System.out.flush();
        String dir = new BufferedReader(new InputStreamReader(System.in)).readLine();
        if (dir != null && !dir.equals("")) {
            OpenACCCHelpBook.writeIndexHTMLFile(dir);
            OpenACCCHelpBook.writeIndividualHTMLFiles(dir);
        }
        System.out.println("All files written.");
    }

    private static void writeIndexHTMLFile(String dir) throws IOException {
        String filename = String.valueOf(dir) + File.separator + "index.html";
        System.out.println("Writing " + filename);
        final FileWriter out = new FileWriter(filename);
        out.write("<html>\n");
        out.write("<head><title>OpenACC&trade; Application Programming Interface Version 1.0</title></head>\n");
        out.write("<body>\n");
        out.write("<h2>OpenACC&trade; Application Programming Interface<br/>\n");
        out.write("    <small><small>Version 1.0</small></small></h2>\n");
        new OpenACCCHelpBook(){

            public void func(String fname, String desc, String retType, String args) {
                try {
                    out.write(String.format("<a href=\"%s.html\">%s</a><br/>\n", fname, fname));
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        };
        out.write("</body>\n");
        out.write("</html>\n");
        ((Writer)out).close();
    }

    private static void writeIndividualHTMLFiles(final String dir) {
        new OpenACCCHelpBook(){

            public void func(String fname, String desc, String retType, String args) {
                String filename = String.valueOf(dir) + File.separator + fname + ".html";
                System.out.println("Writing " + filename);
                try {
                    FileWriter out = new FileWriter(filename);
                    out.write("<html>\n");
                    out.write(String.format("<head><title>%s</title></head>\n", fname));
                    out.write("<body>\n");
                    out.write(String.format("<h2>%s</h2>\n", fname));
                    out.write(String.format("<p style=\"line-height: 150%%;\"><tt>%s <b>%s</b>(%s)</tt></p>\n", this.colorize(retType), fname, this.colorize(args)));
                    out.write(String.format("<dl><dd>%s</dd></dl>\n", this.insertTrademarks(this.formatConstantsAndFunctionNames(desc))));
                    out.write("<br/>\n");
                    out.write("<table width=\"100%\" border=\"0\"><tr>\n");
                    out.write("<td align=\"left\"><font size=\"2\"><a href=\"index.html\">API Index</a></font></td>\n");
                    out.write("<td align=\"right\"><font color=\"#C0C0C0\" size=\"1\">OpenACC&trade; Application Programming Interface Version 1.0</font></td>\n");
                    out.write("</tr></table>\n");
                    out.write("</body>\n");
                    out.write("</html>\n");
                    ((Writer)out).close();
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }

            private String colorize(String args) {
                return args.replace("void", "<b><font color=\"#931a68\">void</font></b>").replace("int", "<b><font color=\"#931a68\">int</font></b>");
            }

            private String formatConstantsAndFunctionNames(String desc) {
                return desc.replaceAll("(acc_[a-z_]+\\(?\\)?)", "<tt>$1</tt>");
            }

            private String insertTrademarks(String description) {
                return description.replace("OpenACC", "OpenACC&trade;");
            }
        };
    }
}

