/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueArray;
import org.eclipse.ptp.internal.debug.core.model.AbstractPVariable;
import org.eclipse.ptp.internal.debug.core.model.PDebugElement;

public abstract class AbstractPValue
extends PDebugElement
implements IPValue {
    private AbstractPVariable fParent = null;

    public AbstractPValue(AbstractPVariable parent) {
        super(parent.getSession(), parent.getTasks());
        this.fParent = parent;
    }

    public abstract void dispose();

    @Override
    public String evaluateAsExpression(IPStackFrame frame) {
        String valueString = "";
        AbstractPVariable parent = this.getParentVariable();
        if (parent != null && frame != null && frame.canEvaluate()) {
            try {
                IAIFValue value = parent.getAIF().getValue();
                if (value instanceof IAIFValueArray) {
                    valueString = "";
                } else {
                    valueString = value.getValueString();
                    if (valueString == null || valueString.length() == 0) {
                        valueString = frame.evaluateExpressionToString(parent.getExpressionString());
                    }
                }
            }
            catch (AIFException e) {
                valueString = e.getMessage();
            }
            catch (DebugException e) {
                valueString = e.getMessage();
            }
        }
        return valueString;
    }

    public AbstractPVariable getParentVariable() {
        return this.fParent;
    }

    protected abstract void preserve();

    protected abstract void reset();

    protected abstract void setChanged(boolean var1);
}

