/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.php.internal.ui.actions.newprojectwizard.NewProjectAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardMenu
extends BaseNewWizardMenu {
    private static final List<String> PROJECT_WIZARD_ID = new ArrayList<String>();
    private final IAction newExampleAction;
    private final IAction newProjectAction;
    private boolean enabled = true;
    private boolean isProject = true;

    static {
        PROJECT_WIZARD_ID.add("org.eclipse.php.ui.wizards.PHPFileCreationWizard");
        PROJECT_WIZARD_ID.add("com.zend.php.ui.wizards.phpElementsWizard.NewPHPClassWizard");
        PROJECT_WIZARD_ID.add("com.zend.php.ui.wizards.phpElementsWizard.NewPHPInterfaceWizard");
        PROJECT_WIZARD_ID.add("com.zend.php.ui.wizards.phpElementsWizard.NewPHPTraitWizard");
        PROJECT_WIZARD_ID.add("org.eclipse.php.ui.wizards.UntitledPHPDocumentWizard");
        PROJECT_WIZARD_ID.add("org.eclipse.ui.wizards.new.folder");
        PROJECT_WIZARD_ID.add("org.eclipse.ui.wizards.new.file");
        PROJECT_WIZARD_ID.add("org.eclipse.wst.css.ui.internal.wizard.NewCSSWizard");
        PROJECT_WIZARD_ID.add("org.eclipse.wst.html.ui.internal.wizard.NewHTMLWizard");
        PROJECT_WIZARD_ID.add("org.eclipse.wst.xml.ui.internal.wizards.NewXMLWizard");
        PROJECT_WIZARD_ID.add("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");
        PROJECT_WIZARD_ID.add("org.zend.php.framework.ui.wizards.NewZendItemWizard");
        PROJECT_WIZARD_ID.add("com.zend.php.ui.wizards.wizards.RemoteFolderWizard");
        PROJECT_WIZARD_ID.add("org.eclipse.php.wst.jsdt.ui.NewJSWizard");
        PROJECT_WIZARD_ID.add("org.eclipse.mylyn.tasks.ui.wizards.new.repository.task");
        PROJECT_WIZARD_ID.add("com.zend.php.phpunit.wizards.TestCaseWizard");
        PROJECT_WIZARD_ID.add("com.zend.php.phpunit.wizards.TestSuiteWizard");
    }

    public NewWizardMenu(IWorkbenchWindow window, boolean isProject) {
        this(window, null, isProject);
    }

    public NewWizardMenu(IWorkbenchWindow window, String id, boolean isProject) {
        super(window, id);
        this.newExampleAction = new NewExampleAction(window);
        this.newProjectAction = new NewProjectAction(window);
        this.isProject = isProject;
    }

    private boolean hasExamples() {
        boolean hasCategory = this.registryHasCategory("org.eclipse.ui.Examples");
        if (hasCategory) {
            IWizardCategory exampleCategory = WorkbenchPlugin.getDefault().getNewWizardRegistry().findCategory("org.eclipse.ui.Examples");
            return this.hasWizards(exampleCategory);
        }
        return false;
    }

    private boolean hasWizards(IWizardCategory category) {
        IWizardDescriptor[] wizards = category.getWizards();
        if (wizards.length > 0) {
            int i = 0;
            while (i < wizards.length) {
                if (!WorkbenchActivityHelper.filterItem((Object)wizards[i])) {
                    return true;
                }
                ++i;
            }
        }
        IWizardCategory[] categories = category.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (this.hasWizards(categories[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addItems(List<IContributionItem> list) {
        List<IContributionItem> shortCuts = new ArrayList<IContributionItem>();
        this.addShortcuts(shortCuts);
        Iterator iterator = shortCuts.iterator();
        while (iterator.hasNext()) {
            Object curr = iterator.next();
            if (!(curr instanceof ActionContributionItem) || !this.isNewProjectWizardAction(((ActionContributionItem)curr).getAction())) continue;
            iterator.remove();
        }
        list.add((IContributionItem)new ActionContributionItem(this.newProjectAction));
        list.add((IContributionItem)new Separator());
        shortCuts = this.sortShortcuts(shortCuts);
        if (!this.isProject && !shortCuts.isEmpty()) {
            list.addAll(shortCuts);
            list.add((IContributionItem)new Separator());
        }
        if (this.hasExamples()) {
            list.add((IContributionItem)new ActionContributionItem(this.newExampleAction));
            list.add((IContributionItem)new Separator());
        }
        list.add((IContributionItem)new ActionContributionItem(this.getShowDialogAction()));
    }

    private List<IContributionItem> sortShortcuts(List<IContributionItem> shortCuts) {
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>();
        for (String id : PROJECT_WIZARD_ID) {
            Iterator<IContributionItem> iterator = shortCuts.iterator();
            while (iterator.hasNext()) {
                NewWizardShortcutAction action;
                ActionContributionItem item;
                IContributionItem curr = iterator.next();
                if (!(curr instanceof ActionContributionItem) || !((item = (ActionContributionItem)curr).getAction() instanceof NewWizardShortcutAction) || !id.equals((action = (NewWizardShortcutAction)item.getAction()).getWizardDescriptor().getId())) continue;
                result.add((IContributionItem)item);
                iterator.remove();
            }
        }
        result.addAll(shortCuts);
        return result;
    }

    private boolean isNewProjectWizardAction(IAction action) {
        if (action instanceof NewWizardShortcutAction) {
            IWizardDescriptor wizardDescriptor = ((NewWizardShortcutAction)action).getWizardDescriptor();
            String[] tags = wizardDescriptor.getTags();
            int i = 0;
            while (i < tags.length) {
                if ("project".equals(tags[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabledValue) {
        this.enabled = enabledValue;
    }

    protected IContributionItem[] getContributionItems() {
        if (this.isEnabled()) {
            return super.getContributionItems();
        }
        return new IContributionItem[0];
    }
}

