/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.api.packages;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.eclipse.php.composer.api.packages.AbstractDownloader;
import org.eclipse.php.composer.api.packages.DownloadListenerInterface;
import org.eclipse.php.composer.api.packages.ProxyHelper;

public class AsyncDownloader
extends AbstractDownloader {
    public static final int TIMEOUT_SECONDS = 30;
    private int lastSlot = 1;
    private Log log = LogFactory.getLog(AsyncDownloader.class);
    private PoolingHttpClientConnectionManager connectionManager;
    private Map<Integer, Connection> connections = new HashMap<Integer, Connection>();

    public AsyncDownloader() {
    }

    public AsyncDownloader(String url) {
        super(url);
    }

    @Override
    protected void init() {
        super.init();
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory ssf = new SSLConnectionSocketFactory(builder.build());
            Registry r = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)ssf).build();
            this.connectionManager = new PoolingHttpClientConnectionManager(r);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"Exception during init", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.log.error((Object)"Exception during init", (Throwable)e);
        }
        catch (KeyStoreException e) {
            this.log.error((Object)"Exception during init", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int download() {
        try {
            slot = ++this.lastSlot;
            connection = new Connection(this.url);
            connection.start();
            this.connections.put(slot, connection);
            return slot;
        }
        catch (Exception e) {
            ** for (listener : this.listeners)
        }
lbl-1000:
        // 1 sources

        {
            listener.errorOccured(e);
            continue;
        }
lbl12:
        // 1 sources

        return -1;
    }

    public void abort() {
        this.abort(this.lastSlot);
    }

    public void abort(int slot) {
        try {
            Connection conn = this.connections.get(slot);
            if (conn != null) {
                conn.abort();
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortListeners(String url) {
        AsyncDownloader asyncDownloader = this;
        synchronized (asyncDownloader) {
            for (DownloadListenerInterface listener : this.listeners) {
                listener.aborted(url);
            }
        }
    }

    public void shutdown() {
        if (this.connectionManager != null) {
            for (Connection conn : this.connections.values()) {
                if (conn == null) continue;
                conn.abort();
            }
            this.connectionManager.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    private class Connection
    implements Runnable {
        private String url;
        private Thread thread;

        public Connection(String url) {
            this.url = url;
        }

        public void closed() {
            AsyncDownloader.this.abortListeners(this.url);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                this.closed();
                return;
            }
            try {
                URI uri = URI.create(this.url);
                HttpClientBuilder httpClientBuilder = ProxyHelper.createHttpClientBuilder(uri);
                httpClientBuilder.setUserAgent("org.eclipse.php.composer.api");
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)AsyncDownloader.this.connectionManager);
                RequestConfig.Builder requestBuilder = RequestConfig.custom();
                requestBuilder = requestBuilder.setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000);
                httpClientBuilder.setDefaultRequestConfig(requestBuilder.build());
                CloseableHttpClient httpClient = httpClientBuilder.build();
                HttpHost target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                HttpGet httpGet = new HttpGet(uri);
                try (CloseableHttpResponse response = null;){
                    if (Thread.currentThread().isInterrupted()) {
                        this.closed();
                        return;
                    }
                    response = httpClient.execute(target, (HttpRequest)httpGet);
                    if (Thread.currentThread().isInterrupted()) {
                        httpGet.abort();
                        this.closed();
                        return;
                    }
                    if (response.getStatusLine().getStatusCode() >= 300) {
                        throw new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
                    }
                    HttpEntity entity = response.getEntity();
                    if (Thread.currentThread().isInterrupted()) {
                        this.closed();
                        return;
                    }
                    if (entity == null) {
                        throw new ClientProtocolException("Response contains no content");
                    }
                    try {
                        AsyncDownloader asyncDownloader = AsyncDownloader.this;
                        synchronized (asyncDownloader) {
                            Iterator iterator = AsyncDownloader.this.listeners.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    return;
                                }
                                DownloadListenerInterface listener = (DownloadListenerInterface)iterator.next();
                                try {
                                    if (Thread.currentThread().isInterrupted()) {
                                        this.closed();
                                        return;
                                    }
                                }
                                catch (Exception e) {
                                    listener.errorOccured(e);
                                    continue;
                                }
                                {
                                    listener.dataReceived(response.getEntity().getContent(), httpGet.getURI().toString());
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                }
            }
            catch (Exception ex) {
                AsyncDownloader asyncDownloader = AsyncDownloader.this;
                synchronized (asyncDownloader) {
                    for (DownloadListenerInterface listener : AsyncDownloader.this.listeners) {
                        listener.errorOccured(ex);
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            Connection connection = this;
            synchronized (connection) {
                if (this.thread != null && this.thread.isAlive()) {
                    this.thread.interrupt();
                }
            }
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }
}

