/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class RemoveExportPackageResolution
extends AbstractManifestMarkerResolution {
    String fPackage;

    public RemoveExportPackageResolution(int type, String pkgName, IMarker marker) {
        super(type, marker);
        this.fPackage = pkgName;
    }

    @Override
    protected void createChange(BundleModel model) {
        this.fPackage = this.marker.getAttribute("packageName", null);
        Bundle bundle = (Bundle)model.getBundle();
        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
        if (header != null) {
            header.removePackage(this.fPackage);
        }
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.RemoveExportPkgs_label, (Object)this.fPackage);
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)PDEUIMessages.RemoveExportPkgs_description, (Object)this.fPackage);
    }
}

