/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.InstallableUnitProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetDefinitionContentAssist;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.DelegateProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.Messages;
import org.eclipse.pde.internal.genericeditor.target.extension.model.LocationNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.Node;
import org.eclipse.pde.internal.genericeditor.target.extension.model.RepositoryCache;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;
import org.osgi.framework.Version;

public class AttributeValueCompletionProcessor
extends DelegateProcessor {
    private String searchTerm;
    private String acKey;
    private int offset;

    public AttributeValueCompletionProcessor(String searchTerm, String acKey, int offset) {
        this.searchTerm = searchTerm;
        this.acKey = acKey;
        this.offset = offset;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals() {
        String repoLocation;
        LocationNode location;
        Parser parser = Parser.getDefault();
        Node rootNode = parser.getRootNode();
        if (rootNode == null) {
            return new ICompletionProposal[0];
        }
        List<Node> locationsNode = rootNode.getChildNodesByTag("locations");
        if (locationsNode == null || locationsNode.isEmpty()) {
            return new ICompletionProposal[0];
        }
        Node locationNode = null;
        for (Node u : locationsNode.get(0).getChildNodesByTag("location")) {
            if (this.offset < u.getOffsetStart() || this.offset >= u.getOffsetEnd()) continue;
            locationNode = u;
            break;
        }
        if (locationNode == null) {
            return new ICompletionProposal[0];
        }
        Node node = null;
        for (Node u : locationNode.getChildNodesByTag("unit")) {
            if (this.offset < u.getOffsetStart() || this.offset >= u.getOffsetEnd()) continue;
            node = (UnitNode)u;
            break;
        }
        if ("id".equalsIgnoreCase(this.acKey) && node != null) {
            if (!(node.getParentNode() instanceof LocationNode)) {
                return this.getErrorCompletion();
            }
            location = (LocationNode)node.getParentNode();
            repoLocation = location.getRepositoryLocation();
            if (repoLocation == null) {
                return this.getErrorCompletion();
            }
            RepositoryCache cache = RepositoryCache.getDefault();
            List<UnitNode> units = cache.fetchP2UnitsFromRepo(repoLocation, false);
            return this.convertToProposals(units);
        }
        if ("version".equalsIgnoreCase(this.acKey) && node != null) {
            if (!(node.getParentNode() instanceof LocationNode)) {
                return this.getErrorCompletion();
            }
            location = (LocationNode)node.getParentNode();
            repoLocation = location.getRepositoryLocation();
            if (repoLocation == null) {
                return this.getErrorCompletion();
            }
            RepositoryCache cache = RepositoryCache.getDefault();
            List<UnitNode> repositoryUnits = cache.fetchP2UnitsFromRepo(repoLocation, false);
            List<String> versions = null;
            for (UnitNode unit : repositoryUnits) {
                if (!unit.getId().equals(((UnitNode)node).getId())) continue;
                versions = unit.getAvailableVersions();
            }
            return this.convertToVersionProposals(versions);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] convertToVersionProposals(List<String> versions) {
        ArrayList<String> dest = new ArrayList<String>();
        dest.addAll(versions);
        Collections.sort(dest, (v1, v2) -> new Version(v2).compareTo(new Version(v1)));
        if (!versions.contains("0.0.0")) {
            dest.add("0.0.0");
        }
        ArrayList<InstallableUnitProposal> result = new ArrayList<InstallableUnitProposal>();
        for (String version : dest) {
            StyledString displayString = TargetDefinitionContentAssist.getFilteredStyledString(version, this.searchTerm);
            if (displayString == null || displayString.length() == 0) continue;
            result.add(new InstallableUnitProposal(displayString, this.offset - this.searchTerm.length(), this.searchTerm.length()));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private ICompletionProposal[] convertToProposals(List<UnitNode> units) {
        Collections.sort(units, (node1, node2) -> String.CASE_INSENSITIVE_ORDER.compare(node1.getId(), node2.getId()));
        ArrayList<InstallableUnitProposal> result = new ArrayList<InstallableUnitProposal>();
        for (UnitNode unit : units) {
            StyledString displayString = TargetDefinitionContentAssist.getFilteredStyledString(unit.getId(), this.searchTerm);
            if (displayString == null || displayString.length() == 0) continue;
            result.add(new InstallableUnitProposal(displayString, this.offset - this.searchTerm.length(), this.searchTerm.length()));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private ICompletionProposal[] getErrorCompletion() {
        String replacementString = Messages.AttributeValueCompletionProcessor_RepositoryRequired;
        return new ICompletionProposal[]{new CompletionProposal("", this.offset, 0, 0, null, replacementString, null, null)};
    }
}

