/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ObjectType;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.RepositoryAccess;
import org.eclipse.objectteams.otre.util.BoundClass;
import org.eclipse.objectteams.otre.util.FieldDescriptor;
import org.eclipse.objectteams.otre.util.ListValueHashMap;
import org.eclipse.objectteams.otre.util.MethodBinding;
import org.eclipse.objectteams.otre.util.RoleBaseBinding;
import org.eclipse.objectteams.otre.util.SuperMethodDescriptor;
import org.objectteams.OTREInternalError;

public class CallinBindingManager {
    private static HashMap<String, RoleBaseBinding> roleBindings;
    private static ListValueHashMap<RoleBaseBinding> baseBindings;
    private static ListValueHashMap<String> basesPerTeam;
    private static ListValueHashMap<String> rolesPerTeam;
    private static LinkedList<String> allRoles;
    private static HashMap<String, Integer> baseCallTags;
    private static HashMap<String, HashMap<String, int[]>> paramMappings;
    private static HashMap<String, HashSet<String>> calloutBindings;
    private static ListValueHashMap<FieldDescriptor> calloutSetFields;
    private static ListValueHashMap<FieldDescriptor> calloutGetFields;
    private static ListValueHashMap<SuperMethodDescriptor> superMethods;
    private static List<String> boundBaseInterfaces;
    private static ListValueHashMap<List<String>> precedencePerTeam;
    static boolean logging;
    static boolean OTEQUINOX_WARN;
    private static ListValueHashMap<ObjectTeamsTransformation.BaseMethodInfo> staticReplaceBindings;
    private static LinkedList<String> baseClassesForModifierChange;

    static {
        String warnlevel;
        roleBindings = new HashMap();
        baseBindings = new ListValueHashMap();
        basesPerTeam = new ListValueHashMap();
        rolesPerTeam = new ListValueHashMap();
        allRoles = new LinkedList();
        baseCallTags = new HashMap();
        paramMappings = new HashMap();
        calloutBindings = new HashMap();
        calloutSetFields = new ListValueHashMap();
        calloutGetFields = new ListValueHashMap();
        superMethods = new ListValueHashMap();
        boundBaseInterfaces = new LinkedList<String>();
        precedencePerTeam = new ListValueHashMap();
        logging = false;
        OTEQUINOX_WARN = false;
        if (System.getProperty("ot.log") != null) {
            logging = true;
        }
        if ((warnlevel = System.getProperty("otequinox.debug")) != null && ((warnlevel = warnlevel.toUpperCase()).startsWith("INFO") || warnlevel.equals("OK"))) {
            OTEQUINOX_WARN = true;
        }
        staticReplaceBindings = new ListValueHashMap();
        baseClassesForModifierChange = new LinkedList();
    }

    public static void addSuperRoleLink(String className, String superClassName) {
        if (!roleBindings.containsKey(superClassName)) {
            return;
        }
        RoleBaseBinding rbbSuper = roleBindings.get(superClassName);
        RoleBaseBinding rbb = roleBindings.get(className);
        rbb.getRoleClass().setSuper(rbbSuper.getRoleClass());
    }

    private static void addSuperBaseLink(String teamClassName, String baseClassName, RoleBaseBinding rbb) {
        BoundClass baseClass = rbb.getBaseClass();
        ObjectType baseClassType = new ObjectType(baseClassName);
        Iterator<Map.Entry<String, LinkedList<RoleBaseBinding>>> it = CallinBindingManager.getBaseBindingsCloneIterator();
        while (it.hasNext()) {
            Map.Entry<String, LinkedList<RoleBaseBinding>> entry = it.next();
            String currentBaseClassName = entry.getKey();
            if (currentBaseClassName.equals(baseClassName)) continue;
            ObjectType currentType = new ObjectType(currentBaseClassName);
            BoundClass currentBaseClass = entry.getValue().getFirst().getBaseClass();
            if (RepositoryAccess.safeSubclassOf(baseClassType, currentType)) {
                BoundClass rbbSuper = baseClass.getSuper();
                if (rbbSuper != null) {
                    if (rbbSuper.getName().equals(currentBaseClassName)) continue;
                    baseClass.updateSuper(currentBaseClass, currentType);
                }
                baseClass.setSuper(currentBaseClass);
                continue;
            }
            if (!RepositoryAccess.safeSubclassOf(currentType, baseClassType)) continue;
            BoundClass currentSuper = currentBaseClass.getSuper();
            if (currentSuper != null) {
                if (currentSuper.getName().equals(baseClassName)) continue;
                currentBaseClass.updateSuper(baseClass, baseClassType);
            }
            currentBaseClass.setSuper(baseClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRoleBaseBinding(String roleClassName, String baseClassName, boolean baseIsInterface, String teamClassName) {
        RoleBaseBinding rbb = roleBindings.get(roleClassName);
        if (rbb == null) {
            rbb = new RoleBaseBinding(roleClassName, baseClassName, baseIsInterface, teamClassName);
            roleBindings.put(roleClassName, rbb);
        }
        CallinBindingManager.addSuperBaseLink(teamClassName, baseClassName, rbb);
        ListValueHashMap<RoleBaseBinding> listValueHashMap = baseBindings;
        synchronized (listValueHashMap) {
            baseBindings.put(baseClassName, rbb);
        }
        CallinBindingManager.addTeamRoleRelation(teamClassName, roleClassName);
    }

    public static void addTeamBaseRelation(String teamClassName, String baseClassName) {
        JavaClass baseClass = null;
        try {
            baseClass = RepositoryAccess.lookupClass(baseClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (baseClass != null && baseClass.isInterface()) {
            if (logging) {
                ObjectTeamsTransformation.printLogMessage("*** Skipping base " + baseClassName + ": is an interface");
                ObjectTeamsTransformation.printLogMessage("Classses implementing the interface " + baseClassName + " have to be transformed!");
            }
            CallinBindingManager.addBoundBaseInterface(baseClassName);
        } else {
            LinkedList<String> bases = basesPerTeam.get(teamClassName);
            if (bases == null || !bases.contains(baseClassName)) {
                basesPerTeam.put(teamClassName, baseClassName);
            }
        }
    }

    public static List<String> getBasesPerTeam(String teamClassName) {
        return basesPerTeam.get(teamClassName);
    }

    public static void addTeamRoleRelation(String teamClassName, String roleClassName) {
        LinkedList<String> roles = rolesPerTeam.get(teamClassName);
        if (roles == null || !roles.contains(roleClassName)) {
            rolesPerTeam.put(teamClassName, roleClassName);
        }
    }

    public static List<String> getRolePerTeam(String teamClassName) {
        return rolesPerTeam.get(teamClassName);
    }

    public static void addRole(String roleName) {
        allRoles.add(roleName);
    }

    public static boolean isRole(String roleName) {
        return allRoles.contains(roleName);
    }

    public static void addMethodBinding(String roleClassName, String baseClassName, String bindingFileName, int bindingLineNumber, int bindingLineOffset, String bindingLabel, String roleMethodName, String roleMethodSignature, boolean isStaticRoleMethod, String wrapperName, String wrapperSignature, String modifier, String baseMethodName, String baseMethodSignature, boolean isStaticBaseMethod, boolean baseIsCallin, boolean covariantBaseReturn, int translationFlags, String liftMethodName, String liftMethodSignature) {
        RoleBaseBinding rbb = roleBindings.get(roleClassName);
        if (rbb == null) {
            if (baseClassName == null) {
                throw new OTREInternalError("PlayedBy attribute must be read before method bindings.");
            }
            int lastDollar = roleClassName.lastIndexOf(36);
            String teamClassName = roleClassName.substring(0, lastDollar);
            rbb = new RoleBaseBinding(roleClassName, baseClassName, false, teamClassName);
            roleBindings.put(roleClassName, rbb);
        }
        rbb.addMethodBinding(bindingFileName, bindingLineNumber, bindingLineOffset, bindingLabel, roleMethodName, roleMethodSignature, isStaticRoleMethod, wrapperName, wrapperSignature, modifier, baseMethodName, baseMethodSignature, isStaticBaseMethod, baseIsCallin, covariantBaseReturn, translationFlags, liftMethodName, liftMethodSignature);
        if (modifier.equals("replace")) {
            CallinBindingManager.assignBaseCallTag(rbb.getBaseClassName(), baseMethodName, baseMethodSignature);
        }
    }

    public static Collection<MethodBinding> getBindingForBaseMethod(String baseClassName, String baseMethodName, String baseMethodSignature) {
        LinkedList<RoleBaseBinding> rbbList = baseBindings.get(baseClassName);
        LinkedList<MethodBinding> resultList = new LinkedList<MethodBinding>();
        if (rbbList != null) {
            for (RoleBaseBinding rbb : rbbList) {
                List<MethodBinding> mbs = rbb.getBaseMethodBindings(baseMethodName, baseMethodSignature);
                if (mbs == null) continue;
                CallinBindingManager.addFiltered(resultList, mbs, baseMethodName, baseMethodSignature);
            }
        }
        CallinBindingManager.addFiltered(resultList, CallinBindingManager.getImplicitlyInheritedBaseMethodBindings(baseClassName, baseMethodName, baseMethodSignature), baseMethodName, baseMethodSignature);
        if (resultList.isEmpty()) {
            return null;
        }
        return resultList;
    }

    public static boolean isBoundBaseMethod(String baseClassName, String baseMethodName, String baseMethodSignature) {
        LinkedList<RoleBaseBinding> rbbList = baseBindings.get(baseClassName);
        if (rbbList != null) {
            for (RoleBaseBinding rbb : rbbList) {
                List<MethodBinding> mbs = rbb.getBaseMethodBindings(baseMethodName, baseMethodSignature);
                if (mbs == null) continue;
                for (MethodBinding mb : mbs) {
                    if (!mb.matchesMethod(baseMethodName, baseMethodSignature, true)) continue;
                    return true;
                }
            }
        }
        for (MethodBinding mb : CallinBindingManager.getImplicitlyInheritedBaseMethodBindings(baseClassName, baseMethodName, baseMethodSignature)) {
            if (!mb.matchesMethod(baseMethodName, baseMethodSignature, true)) continue;
            return true;
        }
        return false;
    }

    private static void addFiltered(Collection<MethodBinding> resultList, Collection<MethodBinding> candidates, String name, String fullSignature) {
        for (MethodBinding methodBinding : candidates) {
            if (!methodBinding.matchesMethod(name, fullSignature, false)) continue;
            resultList.add(methodBinding);
        }
    }

    private static Collection<MethodBinding> getImplicitlyInheritedBaseMethodBindings(String baseClassName, String baseMethodName, String baseMethodSignature) {
        LinkedList<MethodBinding> resultList = new LinkedList<MethodBinding>();
        if (!CallinBindingManager.isRole(baseClassName)) {
            return resultList;
        }
        Iterator<Map.Entry<String, LinkedList<RoleBaseBinding>>> it = CallinBindingManager.getBaseBindingsCloneIterator();
        while (it.hasNext()) {
            List rbbList;
            Map.Entry<String, LinkedList<RoleBaseBinding>> entry = it.next();
            String have = entry.getKey();
            if (have.equals(baseClassName) || !CallinBindingManager.isImplicitSubtype(baseClassName, have)) continue;
            if (logging) {
                ObjectTeamsTransformation.printLogMessage(String.valueOf(baseClassName) + " implicitly inherits callin bindings from " + have);
            }
            if ((rbbList = (List)entry.getValue()) == null) continue;
            for (RoleBaseBinding rbb : rbbList) {
                List<MethodBinding> mbs = rbb.getBaseMethodBindings(baseMethodName, baseMethodSignature);
                if (mbs == null) continue;
                resultList.addAll(mbs);
            }
        }
        return resultList;
    }

    public static Collection<MethodBinding> getInheritedCallinBindings(String className) {
        LinkedList<MethodBinding> result = new LinkedList<MethodBinding>();
        ObjectType current = new ObjectType(className);
        Iterator<Map.Entry<String, LinkedList<RoleBaseBinding>>> it = CallinBindingManager.getBaseBindingsCloneIterator();
        while (it.hasNext()) {
            List rbbList;
            ObjectType haveType;
            Map.Entry<String, LinkedList<RoleBaseBinding>> entry = it.next();
            String have = entry.getKey();
            if (have.equals(className) || !RepositoryAccess.safeSubclassOf(current, haveType = new ObjectType(have))) continue;
            if (logging) {
                ObjectTeamsTransformation.printLogMessage(String.valueOf(className) + " inherits callin bindings from " + have);
            }
            if ((rbbList = (List)entry.getValue()) == null) continue;
            for (RoleBaseBinding rbb : rbbList) {
                result.addAll(rbb.getBaseMethodBindings());
            }
        }
        return result;
    }

    public static Collection<String> getInheritedCallinBindingsForStaticMethods(String className, String methodName, String methodSignature) {
        LinkedList<String> result = new LinkedList<String>();
        ObjectType current = new ObjectType(className);
        Iterator<Map.Entry<String, LinkedList<RoleBaseBinding>>> it = CallinBindingManager.getBaseBindingsCloneIterator();
        boolean getNextClass = false;
        while (it.hasNext()) {
            LinkedList<RoleBaseBinding> rbbList;
            ObjectType haveType;
            Map.Entry<String, LinkedList<RoleBaseBinding>> entry = it.next();
            String have = entry.getKey();
            if (have.equals(className) || !RepositoryAccess.safeSubclassOf(current, haveType = new ObjectType(have))) continue;
            if (logging) {
                ObjectTeamsTransformation.printLogMessage(String.valueOf(className) + " inherits callin bindings from " + have);
            }
            if ((rbbList = entry.getValue()) == null) continue;
            Iterator rbb_it = rbbList.iterator();
            while (rbb_it.hasNext() && !getNextClass) {
                RoleBaseBinding rbb = (RoleBaseBinding)rbb_it.next();
                List<String[]> methods = rbb.getBaseSignatures();
                Iterator<String[]> methodsIter = methods.iterator();
                while (methodsIter.hasNext() && !getNextClass) {
                    String[] aMethod = methodsIter.next();
                    if (!methodName.equals(aMethod[0]) || !methodSignature.equals(aMethod[1])) continue;
                    result.add(have);
                    getNextClass = true;
                }
            }
            if (!getNextClass) continue;
            getNextClass = false;
        }
        return result;
    }

    private static boolean isImplicitSubtype(String subType, String superType) {
        String superTeamName;
        ObjectType superTeamType;
        String pureSuperType;
        int dollarIdxSub = subType.lastIndexOf(36);
        int dollarIdxSuper = superType.lastIndexOf(36);
        if (dollarIdxSub == -1 || dollarIdxSuper == -1) {
            return false;
        }
        String pureSubType = subType.substring(dollarIdxSub + 1, subType.length());
        if (!pureSubType.equals(pureSuperType = superType.substring(dollarIdxSuper + 1, superType.length()))) {
            return false;
        }
        String subTeamName = subType.substring(0, dollarIdxSub);
        ObjectType subTeamType = new ObjectType(subTeamName);
        if (RepositoryAccess.safeSubclassOf(subTeamType, superTeamType = new ObjectType(superTeamName = superType.substring(0, dollarIdxSuper)))) {
            if (logging) {
                ObjectTeamsTransformation.printLogMessage(String.valueOf(subType) + " implicitly inherits method bindings from " + superType);
            }
            return true;
        }
        return false;
    }

    public static List<MethodBinding> getInheritedBaseMethodBindings(String baseClassName, String baseMethodName, String baseMethodSignature) {
        LinkedList<MethodBinding> inheritedMethodBindings = new LinkedList<MethodBinding>();
        if (!CallinBindingManager.isBoundBaseClass(baseClassName)) {
            return inheritedMethodBindings;
        }
        LinkedList<RoleBaseBinding> baseBindingsForBase = baseBindings.get(baseClassName);
        if (baseBindingsForBase == null) {
            return inheritedMethodBindings;
        }
        for (RoleBaseBinding rbb : baseBindingsForBase) {
            BoundClass bc = rbb.getBaseClass();
            while (bc.getSuper() != null) {
                String superRoleName = (bc = bc.getSuper()).getName();
                Collection<MethodBinding> superRoleMethodBindings = CallinBindingManager.getBindingForBaseMethod(superRoleName, baseMethodName, baseMethodSignature);
                if (superRoleMethodBindings == null) continue;
                inheritedMethodBindings.addAll(superRoleMethodBindings);
            }
        }
        return inheritedMethodBindings;
    }

    public static List<MethodBinding> getInheritedRoleMethodBindings(String roleClassName, String roleMethodName, String roleMethodSignature) {
        LinkedList<MethodBinding> inheritedMethodBindings = new LinkedList<MethodBinding>();
        if (!CallinBindingManager.isBoundRoleClass(roleClassName)) {
            return inheritedMethodBindings;
        }
        RoleBaseBinding rbb = roleBindings.get(roleClassName);
        BoundClass bc = rbb.getRoleClass();
        while (bc.getSuper() != null) {
            bc = bc.getSuper();
            String superRoleName = bc.getName();
            List<MethodBinding> superRoleMethodBindings = CallinBindingManager.getBindingsForRoleMethod(superRoleName, roleMethodName, roleMethodSignature);
            inheritedMethodBindings.addAll(superRoleMethodBindings);
        }
        return inheritedMethodBindings;
    }

    public static List<MethodBinding> getBindingsForRoleMethod(String roleClassName, String roleMethodName, String roleMethodSignature) {
        RoleBaseBinding rbb = roleBindings.get(roleClassName);
        if (rbb == null) {
            return new LinkedList<MethodBinding>();
        }
        List<MethodBinding> roleMethodBindings = rbb.getRoleMethodBindings(roleMethodName, roleMethodSignature);
        if (roleMethodBindings == null) {
            return new LinkedList<MethodBinding>();
        }
        return roleMethodBindings;
    }

    public static boolean isBoundBaseClass(String className) {
        boolean result = baseBindings.containsKey(className);
        if (result || !CallinBindingManager.isRole(className)) {
            return result;
        }
        Iterator<String> it = CallinBindingManager.getBaseBindingsKeyIterator();
        while (it.hasNext()) {
            String have = it.next();
            if (have.equals(className) || !CallinBindingManager.isImplicitSubtype(className, have)) continue;
            return true;
        }
        return result;
    }

    public static boolean isBoundBaseAndRoleClass(String className) {
        if (baseBindings.containsKey(className)) {
            return true;
        }
        Iterator<String> it = CallinBindingManager.getBaseBindingsKeyIterator();
        while (it.hasNext()) {
            String have = it.next();
            if (have.equals(className) || !CallinBindingManager.isImplicitSubtype(className, have)) continue;
            return true;
        }
        return false;
    }

    public static BoundSuperKind hasBoundBaseParent(String baseClassName) {
        LinkedList<RoleBaseBinding> rbbList = baseBindings.get(baseClassName);
        if (rbbList != null) {
            for (RoleBaseBinding rbb : rbbList) {
                BoundClass baseSuper = rbb.getBaseClass().getSuper();
                if (baseSuper == null) continue;
                return baseSuper.isInterface ? BoundSuperKind.INTERFACE : BoundSuperKind.CLASS;
            }
        }
        return BoundSuperKind.NONE;
    }

    public static BoundClass getTopmostBoundBaseClass(String baseClassName) {
        LinkedList<RoleBaseBinding> rbbList = baseBindings.get(baseClassName);
        if (rbbList != null) {
            RoleBaseBinding anyRBB = rbbList.get(0);
            BoundClass bc = anyRBB.getBaseClass();
            while (bc.getSuper() != null) {
                if (bc.getSuper().isInterface) break;
                bc = bc.getSuper();
            }
            return bc;
        }
        return null;
    }

    public static boolean teamAdaptsSuperBaseClass(String teamClassName, String baseClassName) {
        LinkedList<RoleBaseBinding> rbbList = baseBindings.get(baseClassName);
        if (rbbList != null && !rbbList.isEmpty()) {
            RoleBaseBinding rbb = rbbList.getFirst();
            BoundClass bc = rbb.getBaseClass().getSuper();
            while (bc != null && !bc.isInterface) {
                if (bc.isAdaptedByTeam(teamClassName)) {
                    return true;
                }
                bc = bc.getSuper();
            }
        }
        return false;
    }

    public static boolean isBoundRoleClass(String className) {
        return roleBindings.containsKey(className);
    }

    public static RoleBaseBinding getRoleBaseBinding(String roleClassName) {
        return roleBindings.get(roleClassName);
    }

    public static List<MethodBinding> getMethodBindingsForRoleClass(String roleClassName) {
        RoleBaseBinding rbb = roleBindings.get(roleClassName);
        return rbb.getRoleMethodBindings();
    }

    public static Set<String> getBoundRoleMethods(String roleClassName) {
        Set<String> roleMethodKeySet = new HashSet<String>();
        if (roleBindings.get(roleClassName) != null) {
            RoleBaseBinding rbb = roleBindings.get(roleClassName);
            roleMethodKeySet = rbb.getRoleMethodSignatures();
        }
        return roleMethodKeySet;
    }

    public static List<MethodBinding> getMethodBindingsForBaseClass(String baseClassName) {
        LinkedList<RoleBaseBinding> rbbList = baseBindings.get(baseClassName);
        LinkedList<MethodBinding> resultList = new LinkedList<MethodBinding>();
        if (rbbList != null) {
            for (RoleBaseBinding rbb : rbbList) {
                resultList.addAll(rbb.getRoleMethodBindings());
            }
        }
        return resultList;
    }

    public static void assignBaseCallTag(String baseClass, String baseMeth, String baseMethodSignature) {
        String key = String.valueOf(baseClass) + "." + baseMeth + "." + baseMethodSignature;
        int tag = baseCallTags.size();
        if (!baseCallTags.containsKey(key)) {
            baseCallTags.put(key, tag);
        }
    }

    public static int getBaseCallTag(String base_class_name, String base_method_name, String base_method_signature) {
        String key = String.valueOf(base_class_name) + "." + base_method_name + "." + base_method_signature;
        return baseCallTags.get(key);
    }

    public static void addParameterBinding(String teamName, String methodWrapper, int[] positions) {
        HashMap<String, Object> teamMap = paramMappings.get(teamName);
        if (teamMap == null) {
            teamMap = new HashMap();
            paramMappings.put(teamName, teamMap);
        }
        teamMap.put(methodWrapper, positions);
    }

    public static boolean hasParamMappings(String teamName, String methodWrapper) {
        HashMap<String, int[]> teamMap = paramMappings.get(teamName);
        if (teamMap == null) {
            return false;
        }
        return teamMap.containsKey(methodWrapper);
    }

    public static int[] getParamPositions(String teamName, String methodWrapper) {
        int[] positions = CallinBindingManager.getExactParamPositions(teamName, methodWrapper);
        if (positions != null) {
            return positions;
        }
        Iterator<String> superTeams = CallinBindingManager.getSuperTeamsWithParamMappigs(teamName).iterator();
        while (superTeams.hasNext()) {
            positions = CallinBindingManager.getExactParamPositions(superTeams.next(), methodWrapper);
            if (positions == null) continue;
            return positions;
        }
        return null;
    }

    private static int[] getExactParamPositions(String teamName, String methodWrapper) {
        HashMap<String, int[]> teamMap = paramMappings.get(teamName);
        if (teamMap == null) {
            return null;
        }
        return teamMap.get(methodWrapper);
    }

    private static List<String> getSuperTeamsWithParamMappigs(String teamName) {
        LinkedList<String> result = new LinkedList<String>();
        try {
            JavaClass[] javaClassArray = RepositoryAccess.getSuperClasses(teamName);
            int n = javaClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                JavaClass superTeam = javaClassArray[n2];
                if (paramMappings.get(superTeam.getClassName()) != null) {
                    result.add(superTeam.getClassName());
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void addCalloutBinding(String clazz, String meth, String sign) {
        HashSet<String> bindings = calloutBindings.get(clazz);
        if (bindings == null) {
            bindings = new HashSet();
            calloutBindings.put(clazz, bindings);
        }
        bindings.add(String.valueOf(meth) + sign);
    }

    public static HashSet<String> getCalloutBindings(String clazz) {
        return calloutBindings.get(clazz);
    }

    public static boolean requiresCalloutAdjustment(HashSet<String> bindings, String method_name, String signature) {
        return bindings.contains(String.valueOf(method_name) + signature);
    }

    public static void addCalloutBoundFileds(String baseClassName, String fieldName, String fieldSignature, String accessMode, boolean isStaticField) {
        FieldDescriptor fd = new FieldDescriptor(fieldName, fieldSignature, isStaticField);
        if (accessMode.equals("get")) {
            calloutGetFields.put(baseClassName, fd);
        } else if (accessMode.equals("set")) {
            calloutSetFields.put(baseClassName, fd);
        } else {
            throw new OTREInternalError("CalloutFieldAccess attribute contains wrong access mode: " + accessMode);
        }
    }

    public static List<FieldDescriptor> getCalloutGetFields(String baseClassName) {
        return calloutGetFields.get(baseClassName);
    }

    public static List<FieldDescriptor> getCalloutSetFields(String baseClassName) {
        return calloutSetFields.get(baseClassName);
    }

    public static void addSuperAccess(String baseClassName, String superClassName, String methodName, String signature) {
        SuperMethodDescriptor superMethod = new SuperMethodDescriptor(methodName, baseClassName, superClassName, signature);
        superMethods.put(baseClassName, superMethod);
    }

    public static List<SuperMethodDescriptor> getSuperAccesses(String class_name) {
        return superMethods.get(class_name);
    }

    public static void addBoundBaseInterface(String baseInterfaceName) {
        if (!boundBaseInterfaces.contains(baseInterfaceName)) {
            boundBaseInterfaces.add(baseInterfaceName);
        }
    }

    public static Collection<String[]> getInterfaceInheritedCallinBindings(String interfaceName) {
        LinkedList<String[]> result = new LinkedList<String[]>();
        if (boundBaseInterfaces.contains(interfaceName)) {
            LinkedList<RoleBaseBinding> rbbList;
            if (logging) {
                ObjectTeamsTransformation.printLogMessage(String.valueOf(interfaceName) + " bequests callin bindings to implementing class");
            }
            if ((rbbList = baseBindings.get(interfaceName)) != null) {
                for (RoleBaseBinding rbb : rbbList) {
                    result.addAll(rbb.getBaseSignatures());
                }
            }
        }
        return result;
    }

    public static Collection<MethodBinding> getInterfaceInheritedMethodBindings(String methodName, String methodSignature, String interfaceName) {
        LinkedList<RoleBaseBinding> rbbList;
        LinkedList<MethodBinding> result = new LinkedList<MethodBinding>();
        if (boundBaseInterfaces.contains(interfaceName) && (rbbList = baseBindings.get(interfaceName)) != null) {
            for (RoleBaseBinding rbb : rbbList) {
                List<MethodBinding> mbs = rbb.getBaseMethodBindings(methodName, methodSignature);
                if (mbs == null) continue;
                result.addAll(mbs);
            }
        }
        return result;
    }

    public static boolean containsBoundBaseInterface(String[] interfaceNames) {
        int i = 0;
        while (i < interfaceNames.length) {
            if (boundBaseInterfaces.contains(interfaceNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void addPrecedenceList(List<String> precedenceList, String teamName) {
        precedencePerTeam.put(teamName, precedenceList);
    }

    public static List<MethodBinding> sortMethodBindings(List<MethodBinding> mbList, String teamName) {
        if (mbList.size() < 2) {
            return mbList;
        }
        int dollarIdx = teamName.indexOf(36);
        String outermostTeamName = dollarIdx > 0 ? teamName.substring(0, dollarIdx) : teamName;
        LinkedList<List<String>> precedenceList = precedencePerTeam.get(outermostTeamName);
        if (precedenceList == null) {
            return CallinBindingManager.removeOverridden(mbList);
        }
        LinkedList<MethodBinding> sortedMethodBindings = new LinkedList<MethodBinding>();
        for (List list : precedenceList) {
            Iterator plainIt = list.iterator();
            while (plainIt.hasNext()) {
                boolean foundOne = false;
                String label = (String)plainIt.next();
                Iterator<MethodBinding> mbIter = mbList.iterator();
                LinkedList<MethodBinding> alreadySorted = new LinkedList<MethodBinding>();
                while (mbIter.hasNext()) {
                    MethodBinding mb = mbIter.next();
                    if (mb.getQualifiedBindingLabel().equals(label)) {
                        alreadySorted.add(mb);
                        if (!foundOne) {
                            sortedMethodBindings.add(mb);
                            foundOne = true;
                            continue;
                        }
                        CallinBindingManager.checkInheritance(sortedMethodBindings.getLast(), mb);
                        continue;
                    }
                    if (!mb.inheritsBindingLabel(label, teamName)) continue;
                    alreadySorted.add(mb);
                    if (!foundOne) {
                        sortedMethodBindings.add(mb);
                        foundOne = true;
                        continue;
                    }
                    MethodBinding lastAdded = sortedMethodBindings.getLast();
                    if (mb.overridesMethodBinding(lastAdded)) {
                        sortedMethodBindings.set(sortedMethodBindings.size() - 1, mb);
                        foundOne = true;
                        continue;
                    }
                    CallinBindingManager.checkInheritance(sortedMethodBindings.getLast(), mb);
                }
                if (!foundOne) continue;
                for (MethodBinding mb : alreadySorted) {
                    mbList.remove(mb);
                }
            }
        }
        return sortedMethodBindings;
    }

    private static List<MethodBinding> removeOverridden(List<MethodBinding> mbList) {
        MethodBinding mostSpecificMB = mbList.get(0);
        for (MethodBinding mb : mbList) {
            if (mb.overridesMethodBinding(mostSpecificMB)) {
                mostSpecificMB = mb;
                continue;
            }
            CallinBindingManager.checkInheritance(mostSpecificMB, mb);
        }
        LinkedList<MethodBinding> resultList = new LinkedList<MethodBinding>();
        resultList.add(mostSpecificMB);
        return resultList;
    }

    private static void checkInheritance(MethodBinding subMB, MethodBinding superMB) {
        if (!subMB.equals(superMB) && !subMB.overridesMethodBinding(superMB)) {
            throw new OTREInternalError("Wrong assumption! Broken precedence list possible.");
        }
    }

    public static void addStaticReplaceBindingForRoleMethod(String roleMethodKey, ObjectTeamsTransformation.BaseMethodInfo baseMethodInfo) {
        staticReplaceBindings.synchronizedPut(roleMethodKey, baseMethodInfo);
    }

    public static LinkedList<ObjectTeamsTransformation.BaseMethodInfo> getStaticReplaceBindingsForRoleMethod(String roleMethodKey) {
        return staticReplaceBindings.get(roleMethodKey);
    }

    public static boolean roleMethodHasBinding(String roleClassName, String roleMethodName, String roleMethodSignature) {
        RoleBaseBinding rbb = roleBindings.get(roleClassName);
        if (rbb == null) {
            return false;
        }
        return rbb.hasRoleMethodBinding(roleMethodName, roleMethodSignature);
    }

    public static void addBaseClassForModifierChange(String className) {
        baseClassesForModifierChange.add(className);
    }

    public static boolean checkBaseClassModifierChange(String className) {
        Iterator iter = baseClassesForModifierChange.iterator();
        while (iter.hasNext()) {
            if (!className.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBoundSuperclassLink(String sub_name, String super_name) {
        ListValueHashMap<RoleBaseBinding> listValueHashMap = baseBindings;
        synchronized (listValueHashMap) {
            block3: for (RoleBaseBinding subBinding : baseBindings.getFlattenValues()) {
                if (!subBinding.getBaseClassName().equals(sub_name)) continue;
                for (RoleBaseBinding superBinding : baseBindings.getFlattenValues()) {
                    if (subBinding == superBinding || !superBinding.getBaseClassName().equals(super_name)) continue;
                    subBinding.getBaseClass().setSuper(superBinding.getBaseClass());
                    break block3;
                }
            }
        }
    }

    public static BoundClass getBoundBaseClass(String className, String teamClassName) {
        for (RoleBaseBinding subBinding : baseBindings.getFlattenValues()) {
            if (!subBinding.getBaseClassName().equals(className)) continue;
            BoundClass baseClass = subBinding.getBaseClass();
            baseClass.addAdaptingTeam(teamClassName);
            return baseClass;
        }
        return new BoundClass(className, teamClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> getBaseBindingsKeyIterator() {
        ListValueHashMap<RoleBaseBinding> listValueHashMap = baseBindings;
        synchronized (listValueHashMap) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(baseBindings.keySet());
            Iterator<String> it = list.iterator();
            return it;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<Map.Entry<String, LinkedList<RoleBaseBinding>>> getBaseBindingsCloneIterator() {
        ListValueHashMap<RoleBaseBinding> listValueHashMap = baseBindings;
        synchronized (listValueHashMap) {
            ArrayList<Map.Entry<String, LinkedList<RoleBaseBinding>>> list = new ArrayList<Map.Entry<String, LinkedList<RoleBaseBinding>>>();
            list.addAll(baseBindings.entrySet());
            Iterator<Map.Entry<String, LinkedList<RoleBaseBinding>>> it = list.iterator();
            return it;
        }
    }

    public static enum BoundSuperKind {
        NONE,
        CLASS,
        INTERFACE;

    }
}

