/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public final class CheckUtil {
    public static final boolean HAS_DEBUGGER_ATTACHED = CheckUtil.hasDebuggerAttached();
    public static final boolean SANITIZE_TIMEOUT = OMPlatform.INSTANCE.isProperty("org.eclipse.net4j.util.CheckUtil.sanitizeTimeout", HAS_DEBUGGER_ATTACHED);
    private static final long ONE_DAY = 86400000L;
    private static int counter;

    private CheckUtil() {
    }

    public static void checkNull(Object handle, String msg) throws NullPointerException {
        if (handle == null) {
            throw new NullPointerException(msg);
        }
    }

    public static void checkArg(boolean expr, String msg) throws IllegalArgumentException {
        if (!expr) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkArg(Object handle, String handleName) throws IllegalArgumentException {
        if (handle == null) {
            throw new IllegalArgumentException(String.valueOf(handleName) + " is null");
        }
    }

    public static void checkState(boolean expr, String msg) throws IllegalStateException {
        if (!expr) {
            throw new IllegalStateException(msg);
        }
    }

    public static void checkState(Object handle, String handleName) throws IllegalStateException {
        if (handle == null) {
            throw new IllegalStateException(String.valueOf(handleName) + " is null");
        }
    }

    public static void countUp(String message) {
        IOUtil.OUT().println(String.valueOf(message) + ++counter);
    }

    public static void countDown(String message) {
        IOUtil.OUT().println(String.valueOf(message) + --counter);
    }

    public static long sanitizeTimeout(long timeout) {
        if (SANITIZE_TIMEOUT) {
            timeout = Math.max(timeout, 86400000L);
        }
        return timeout;
    }

    private static boolean hasDebuggerAttached() {
        try {
            String property = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.util.CheckUtil.hasDebuggerAttached");
            if (property != null) {
                return Boolean.parseBoolean(property);
            }
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            String jvmArguments = runtimeMXBean.getInputArguments().toString();
            return jvmArguments.contains("-agentlib:jdwp");
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

