/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tcp.ssl;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.cert.X509Certificate;
import org.eclipse.net4j.internal.tcp.ssl.SSLAcceptorFactory;
import org.eclipse.net4j.internal.tcp.ssl.SSLConnectorFactory;
import org.eclipse.net4j.internal.tcp.ssl.SSLProperties;
import org.eclipse.net4j.tcp.ITCPAcceptor;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class SSLUtil {
    private static final String PROTOCOL = "TLSv1.2";
    private static final String X509_CERTIFICATE_TYPE = "X.509";
    private static String configFile;
    private static String keyPathVar;
    private static String trustPathVar;
    private static String passPhraseVar;
    private static int handShakeTimeOutVar;
    private static int handShakeWaitTimeVar;

    static {
        handShakeTimeOutVar = 12;
        handShakeWaitTimeVar = 60;
    }

    public static synchronized void setDefaultSSLConfiguration(String keyPath, String trustPath, String passPhrase) {
        keyPathVar = keyPath;
        trustPathVar = trustPath;
        passPhraseVar = passPhrase;
    }

    public static synchronized void setDefaultSSLConfiguration(String keyPath, String trustPath, String passPhrase, int handShakeTimeOut, int handShakeWaitTime) {
        SSLUtil.setDefaultSSLConfiguration(keyPath, trustPath, passPhrase);
        handShakeTimeOutVar = handShakeTimeOut;
        handShakeWaitTimeVar = handShakeWaitTime;
    }

    public static synchronized void setSSLConfigurationFile(String file) {
        configFile = file;
    }

    public static synchronized void prepareContainer(IManagedContainer container) {
        TCPUtil.prepareContainer(container);
        container.registerFactory((IFactory)new SSLAcceptorFactory());
        container.registerFactory((IFactory)new SSLConnectorFactory());
    }

    public static synchronized ITCPAcceptor getAcceptor(IManagedContainer container, String description) {
        return (ITCPAcceptor)container.getElement("org.eclipse.net4j.acceptors", "ssl", description);
    }

    public static synchronized ITCPConnector getConnector(IManagedContainer container, String description) {
        return (ITCPConnector)container.getElement("org.eclipse.net4j.connectors", "ssl", description);
    }

    public static synchronized SSLEngine createSSLEngine(boolean client, String host, int port) throws Exception {
        String value;
        SSLProperties sslProperties = new SSLProperties();
        String keyPath = sslProperties.getKeyPath();
        String trustPath = sslProperties.getTrustPath();
        String passPhrase = sslProperties.getPassPhrase();
        if ((keyPath == null || trustPath == null || passPhrase == null) && configFile != null) {
            sslProperties.load(configFile);
        }
        if (keyPath == null && (keyPath = sslProperties.getKeyPath()) == null) {
            keyPath = keyPathVar;
        }
        if (trustPath == null && (trustPath = sslProperties.getTrustPath()) == null) {
            trustPath = trustPathVar;
        }
        if (passPhrase == null && (passPhrase = sslProperties.getPassPhrase()) == null) {
            passPhrase = passPhraseVar;
        }
        if ((value = sslProperties.getHandShakeTimeOut()) != null) {
            handShakeTimeOutVar = Integer.parseInt(value);
        }
        if ((value = sslProperties.getHandShakeWaitTime()) != null) {
            handShakeWaitTimeVar = Integer.parseInt(value);
        }
        if (keyPath == null && !client || trustPath == null && client || passPhrase == null) {
            if (client) {
                throw new KeyStoreException("Trust Store[" + (trustPath != null) + "] or Pass Phrase[" + (passPhrase != null) + "] is not provided. [false] means it does not exist.");
            }
            throw new KeyStoreException("Key Store[" + (keyPath != null) + "] or Pass Phrase[" + (passPhrase != null) + "] is not provided. [false] means it does not exist.");
        }
        char[] pass = passPhrase.toCharArray();
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        boolean checkValidtyStatus = OMPlatform.INSTANCE.isProperty("check.validity.certificate", true);
        if (client) {
            KeyStore ksTrust = SSLUtil.createKeyStore(trustPath, pass, checkValidtyStatus);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ksTrust);
            trustManagers = tmf.getTrustManagers();
        } else {
            KeyStore ksKeys = SSLUtil.createKeyStore(keyPath, pass, checkValidtyStatus);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ksKeys, pass);
            keyManagers = kmf.getKeyManagers();
        }
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(keyManagers, trustManagers, null);
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        sslEngine.setUseClientMode(client);
        return sslEngine;
    }

    private static KeyStore createKeyStore(String path, char[] password, boolean checkValidity) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream in = null;
        try {
            in = new URL(path).openStream();
            keyStore.load(in, password);
            if (checkValidity) {
                Enumeration<String> aliasesIter = keyStore.aliases();
                while (aliasesIter.hasMoreElements()) {
                    String alias = aliasesIter.nextElement();
                    Certificate cert = keyStore.getCertificate(alias);
                    if (cert.getType() != X509_CERTIFICATE_TYPE) continue;
                    X509Certificate x509cert = X509Certificate.getInstance(cert.getEncoded());
                    x509cert.checkValidity();
                }
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close((Closeable)in);
        return keyStore;
    }

    public static synchronized int getHandShakeTimeOut() {
        return handShakeTimeOutVar;
    }

    public static synchronized int getHandShakeWaitTime() {
        return handShakeWaitTimeVar;
    }
}

