/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.twiki;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.parser.markup.phrase.HtmlEndTagPhraseModifier;
import org.eclipse.mylyn.wikitext.parser.markup.phrase.HtmlStartTagPhraseModifier;
import org.eclipse.mylyn.wikitext.parser.markup.token.EntityReferenceReplacementToken;
import org.eclipse.mylyn.wikitext.parser.markup.token.ImpliedHyperlinkReplacementToken;
import org.eclipse.mylyn.wikitext.twiki.internal.block.DefinitionListBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.block.HeadingBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.block.HorizontalRuleBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.block.ListBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.block.LiteralBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.block.TableOfContentsBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.block.VerbatimBlock;
import org.eclipse.mylyn.wikitext.twiki.internal.phrase.AutoLinkSwitchPhraseModifier;
import org.eclipse.mylyn.wikitext.twiki.internal.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.wikitext.twiki.internal.token.IconReplacementToken;
import org.eclipse.mylyn.wikitext.twiki.internal.token.ImpliedEmailLinkReplacementToken;
import org.eclipse.mylyn.wikitext.twiki.internal.token.LinkReplacementToken;
import org.eclipse.mylyn.wikitext.twiki.internal.token.WikiWordReplacementToken;

public class TWikiLanguage
extends AbstractMarkupLanguage {
    private final AbstractMarkupLanguage.PatternBasedSyntax literalTokenSyntax = new AbstractMarkupLanguage.PatternBasedSyntax();
    private final AbstractMarkupLanguage.PatternBasedSyntax literalPhraseModifierSyntax = new AbstractMarkupLanguage.PatternBasedSyntax();
    private boolean literalMode;
    private boolean isAutoLinking = true;
    private String iconPattern = "TWikiDocGraphics/{0}.gif";

    public TWikiLanguage() {
        this.setName("TWiki");
        this.setInternalLinkPattern("/cgi-bin/view/{0}/{1}");
    }

    protected AbstractMarkupLanguage.PatternBasedSyntax getPhraseModifierSyntax() {
        return this.literalMode ? this.literalPhraseModifierSyntax : this.phraseModifierSyntax;
    }

    protected AbstractMarkupLanguage.PatternBasedSyntax getReplacementTokenSyntax() {
        return this.literalMode ? this.literalTokenSyntax : this.tokenSyntax;
    }

    protected void clearLanguageSyntax() {
        super.clearLanguageSyntax();
        this.literalTokenSyntax.clear();
        this.literalPhraseModifierSyntax.clear();
    }

    private Block paragraphBreakingBlock(Block block) {
        this.paragraphBreakingBlocks.add(block);
        return block;
    }

    public boolean computeInternalLinkExists(String link) {
        return true;
    }

    public String toInternalHref(String pageName) {
        String[] parts = pageName.split("\\.");
        if (parts.length == 1) {
            parts = new String[]{"Main", parts[0]};
        }
        return MessageFormat.format(this.internalLinkPattern, parts);
    }

    public String toIconUrl(String iconType) {
        return MessageFormat.format(this.getIconPattern(), iconType);
    }

    public boolean isLiteralMode() {
        return this.literalMode;
    }

    public void setLiteralMode(boolean literalMode) {
        this.literalMode = literalMode;
    }

    public void setIconPattern(String iconPattern) {
        this.iconPattern = iconPattern;
    }

    public String getIconPattern() {
        return this.iconPattern;
    }

    public boolean isAutoLinking() {
        return this.isAutoLinking;
    }

    public void setAutoLinking(boolean isAutoLinking) {
        this.isAutoLinking = isAutoLinking;
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add(this.paragraphBreakingBlock(new VerbatimBlock()));
        blocks.add(this.paragraphBreakingBlock(new LiteralBlock()));
        blocks.add(this.paragraphBreakingBlock(new HorizontalRuleBlock()));
        blocks.add(this.paragraphBreakingBlock(new HeadingBlock()));
        blocks.add(this.paragraphBreakingBlock(new DefinitionListBlock()));
        blocks.add(this.paragraphBreakingBlock(new TableOfContentsBlock()));
        blocks.add(this.paragraphBreakingBlock(new ListBlock()));
    }

    protected void addStandardPhraseModifiers(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        boolean escapingHtml = this.configuration == null ? false : this.configuration.isEscapingHtmlAndXml();
        phraseModifierSyntax.add((PatternBasedElement)new AutoLinkSwitchPhraseModifier());
        if (!escapingHtml) {
            phraseModifierSyntax.add((PatternBasedElement)new HtmlStartTagPhraseModifier());
            phraseModifierSyntax.add((PatternBasedElement)new HtmlEndTagPhraseModifier());
        }
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("*", DocumentBuilder.SpanType.BOLD));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("__", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("_", DocumentBuilder.SpanType.ITALIC));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("==", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.MONOSPACE}));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("=", DocumentBuilder.SpanType.MONOSPACE));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        this.literalPhraseModifierSyntax.add((PatternBasedElement)new HtmlStartTagPhraseModifier());
        this.literalPhraseModifierSyntax.add((PatternBasedElement)new HtmlEndTagPhraseModifier());
    }

    protected void addStandardTokens(AbstractMarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new LinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedEmailLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new WikiWordReplacementToken());
        tokenSyntax.add((PatternBasedElement)new IconReplacementToken());
        this.literalTokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
    }

    protected Block createParagraphBlock() {
        return new ParagraphBlock();
    }
}

